/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.handlers;

import com.mrcrayfish.framework.network.message.IMessage;
import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.client.render.renderers.misc.DeathFxRenderer;
import com.nukateam.ntgl.client.settings.NtglOptions;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.handler.ClientActions;
import com.nukateam.ntgl.client.util.handler.ClientMeleeHandler;
import com.nukateam.ntgl.client.util.handler.ClientReloadHandler;
import com.nukateam.ntgl.client.util.handler.ClientShootingHandler;
import com.nukateam.ntgl.client.util.handler.ClientThrowHandler;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.entity.FlyingGib;
import com.nukateam.ntgl.common.foundation.init.ModEntityTypes;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.PacketHandler;
import com.nukateam.ntgl.common.network.message.C2SMessageAttachments;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputHandler {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientShootingHandler.isInGame()) {
            InputHandler.handleKeys();
            InputHandler.handleDebugKeys();
            InputHandler.handleWeaponKeys();
        }
    }

    public static void handleWeaponKeys() {
        WeaponData data;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Options options = Minecraft.m_91087_().f_91066_;
        assert (player != null);
        ItemStack mainHandItem = player.m_21205_();
        ItemStack offhandItem = player.m_21206_();
        if (WeaponModifierHelper.isWeaponItem(mainHandItem)) {
            data = new WeaponData(mainHandItem, (LivingEntity)player);
            if (InputHandler.isKeyAttackDown()) {
                data.setWeaponMode(WeaponMode.PRIMARY);
                InputHandler.handleInput(data, InteractionHand.MAIN_HAND, options.f_92096_);
            } else if (!(!InputHandler.isUseKeyDown() || WeaponModifierHelper.isWeaponItem(offhandItem) && WeaponModifierHelper.canUseOffhandWeapon((LivingEntity)player))) {
                data.setWeaponMode(WeaponMode.SECONDARY);
                InputHandler.handleInput(data, InteractionHand.MAIN_HAND, options.f_92095_);
            } else if (NtglKeyBinds.KEY_ADD_ATTACK.m_90857_()) {
                data.setWeaponMode(WeaponMode.ADDITIONAL);
                InputHandler.handleInput(data, InteractionHand.MAIN_HAND, NtglKeyBinds.KEY_ADD_ATTACK);
            } else if (NtglKeyBinds.KEY_ALT_ATTACK.m_90857_()) {
                data.setWeaponMode(WeaponMode.ALTERNATIVE);
                InputHandler.handleInput(data, InteractionHand.MAIN_HAND, NtglKeyBinds.KEY_ALT_ATTACK);
            }
        }
        if (WeaponModifierHelper.isWeaponItem(offhandItem) && WeaponModifierHelper.canUseOffhandWeapon((LivingEntity)player)) {
            data = new WeaponData(offhandItem, (LivingEntity)player);
            if (InputHandler.isUseKeyDown()) {
                data.setWeaponMode(WeaponMode.PRIMARY);
                InputHandler.handleInput(data, InteractionHand.OFF_HAND, options.f_92095_);
            } else if (!WeaponModifierHelper.isWeaponItem(mainHandItem)) {
                if (NtglKeyBinds.KEY_ADD_ATTACK.m_90857_()) {
                    data.setWeaponMode(WeaponMode.ADDITIONAL);
                    InputHandler.handleInput(data, InteractionHand.OFF_HAND, NtglKeyBinds.KEY_ADD_ATTACK);
                } else if (NtglKeyBinds.KEY_ALT_ATTACK.m_90857_()) {
                    data.setWeaponMode(WeaponMode.ALTERNATIVE);
                    Ntgl.LOGGER.debug("!!! Alt down");
                    InputHandler.handleInput(data, InteractionHand.OFF_HAND, NtglKeyBinds.KEY_ALT_ATTACK);
                }
            }
        }
    }

    public static void handleInput(WeaponData gunData, InteractionHand hand, KeyMapping key) {
        assert (Minecraft.m_91087_().f_91074_ != null);
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack weapon = player.m_21120_(hand);
        if (weapon.m_41720_() instanceof IWeapon) {
            WeaponAction weaponMode = WeaponModifierHelper.getWeaponAction(gunData);
            if (weaponMode == WeaponAction.SHOT) {
                ClientShootingHandler.get().handleInput(gunData, hand, key);
            } else if (weaponMode == WeaponAction.MELEE) {
                ClientMeleeHandler.handleInput(gunData, hand, key);
            }
            if (weaponMode == WeaponAction.THROW) {
                ClientThrowHandler.handleInput(gunData, hand, key);
            }
        }
    }

    private static boolean isKeyAttackDown() {
        return Minecraft.m_91087_().f_91066_.f_92096_.m_90857_();
    }

    private static boolean isUseKeyDown() {
        return Minecraft.m_91087_().f_91066_.f_92095_.m_90857_();
    }

    private static void handleKeys() {
        InteractionHand hand;
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        boolean shiftDown = minecraft.f_91066_.f_92090_.m_90857_();
        InteractionHand interactionHand = hand = shiftDown ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        if (player == null || !ClientShootingHandler.isInGame()) {
            return;
        }
        Item heldItem = player.m_21120_(hand).m_41720_();
        if (heldItem instanceof IWeapon) {
            if (NtglKeyBinds.KEY_ATTACHMENTS.m_90859_()) {
                PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageAttachments());
            }
            if (NtglKeyBinds.KEY_RELOAD.m_90859_()) {
                ClientReloadHandler.get().startReloading();
            }
            if (NtglKeyBinds.KEY_UNLOAD.m_90859_()) {
                ClientReloadHandler.get().unloadAmmo(InteractionHand.MAIN_HAND);
                ClientReloadHandler.get().unloadAmmo(InteractionHand.OFF_HAND);
            }
            if (NtglKeyBinds.KEY_INSPECT.m_90859_()) {
                ClientActions.inspectWeapon(player);
            }
            if (NtglKeyBinds.KEY_FIRE_SELECT.m_90859_()) {
                ClientActions.switchFireMode(hand);
            }
            if (NtglKeyBinds.KEY_AMMO_SELECT.m_90859_()) {
                ClientActions.switchAmmo(hand, player);
            }
            if (NtglKeyBinds.KEY_TIPS.m_90859_()) {
                NtglOptions options;
                options.setShowTips(!(options = NtglOptions.getInstance()).isShowTips());
                options.saveOptions();
            }
        }
    }

    private static void handleDebugKeys() {
        if (Ntgl.isDebugging()) {
            if (NtglKeyBinds.KEY_DEBUG_X_ADD.m_90859_()) {
                ++ClientDebug.X;
            } else if (NtglKeyBinds.KEY_DEBUG_Y_ADD.m_90859_()) {
                ++ClientDebug.Y;
            } else if (NtglKeyBinds.KEY_DEBUG_Z_ADD.m_90859_()) {
                ++ClientDebug.Z;
            } else if (NtglKeyBinds.KEY_DEBUG_X_SUB.m_90859_()) {
                --ClientDebug.X;
            } else if (NtglKeyBinds.KEY_DEBUG_Y_SUB.m_90859_()) {
                --ClientDebug.Y;
            } else if (NtglKeyBinds.KEY_DEBUG_Z_SUB.m_90859_()) {
                --ClientDebug.Z;
            } else if (NtglKeyBinds.KEY_DEBUG_SHOW.m_90859_()) {
                ClientDebug.isHidden = !ClientDebug.isHidden;
            } else if (NtglKeyBinds.KEY_DEBUG_ZERO.m_90859_()) {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                FlyingGib entity = new FlyingGib((EntityType<FlyingGib>)((EntityType)ModEntityTypes.FLYING_GIBS.get()), (Level)level);
                entity.m_146884_(Minecraft.m_91087_().f_91074_.m_20182_());
                DeathFxRenderer.addClientEntity(entity);
                ClientDebug.X = 0;
                ClientDebug.Y = 0;
                ClientDebug.Z = 0;
            }
        }
    }
}

