/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.helpers;

import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemDisplayContext;

public class TransformUtils {
    private static final Set<ItemDisplayContext> NON_HAND_TRANSFORM_TYPES = Collections.unmodifiableSet(EnumSet.of(ItemDisplayContext.GUI, ItemDisplayContext.GROUND, ItemDisplayContext.FIXED));

    public static boolean isHandTransform(ItemDisplayContext transformType) {
        return switch (transformType) {
            case ItemDisplayContext.FIRST_PERSON_RIGHT_HAND, ItemDisplayContext.FIRST_PERSON_LEFT_HAND, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, ItemDisplayContext.THIRD_PERSON_LEFT_HAND -> true;
            default -> false;
        };
    }

    public static InteractionHand getHand(ItemDisplayContext transformType) {
        return TransformUtils.isRightHand(transformType) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
    }

    public static boolean isRightHand(ItemDisplayContext transformType) {
        return transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    public static boolean isFirstPerson(ItemDisplayContext transformType) {
        return transformType == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
    }

    public static boolean isThirdPerson(ItemDisplayContext transformType) {
        return transformType == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND || transformType == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    public static boolean isNonHand(ItemDisplayContext transformType) {
        return NON_HAND_TRANSFORM_TYPES.contains(transformType);
    }
}

