/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class ExplosionConfig
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    public static final String DAMAGE = "Damage";
    public static final String DISTANCE = "DamageReduceOverDistance";
    public static final String CAUSE_FIRE = "CauseFire";
    public static final String EXPLOSION_RADIUS = "ExplosionRadius";
    public static final String DESTROY_BLOCKS = "DestroyBlocks";
    public static final String EXPLODE_ON_CONTACT = "explodeOnContact";
    public static final String KNOCKBACK = "knockback";
    @Optional
    private float damage = 0.0f;
    @Optional
    private boolean damageReduceOverDistance = true;
    @Optional
    private boolean causeFire = false;
    @Optional
    private boolean destroyBlocks = false;
    @Optional
    private boolean explodeOnContact = true;
    @Optional
    private float radius;
    @Optional
    private float knockback;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128350_(DAMAGE, this.damage);
        tag.m_128350_(EXPLOSION_RADIUS, this.radius);
        tag.m_128350_(KNOCKBACK, this.knockback);
        tag.m_128379_(DISTANCE, this.damageReduceOverDistance);
        tag.m_128379_(CAUSE_FIRE, this.causeFire);
        tag.m_128379_(DESTROY_BLOCKS, this.destroyBlocks);
        tag.m_128379_(EXPLODE_ON_CONTACT, this.explodeOnContact);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_(DAMAGE, 99)) {
            this.damage = tag.m_128457_(DAMAGE);
        }
        if (tag.m_128425_(EXPLOSION_RADIUS, 99)) {
            this.radius = tag.m_128457_(EXPLOSION_RADIUS);
        }
        if (tag.m_128425_(KNOCKBACK, 99)) {
            this.knockback = tag.m_128457_(KNOCKBACK);
        }
        if (tag.m_128425_(DISTANCE, 99)) {
            this.damageReduceOverDistance = tag.m_128471_(DISTANCE);
        }
        if (tag.m_128425_(CAUSE_FIRE, 99)) {
            this.causeFire = tag.m_128471_(CAUSE_FIRE);
        }
        if (tag.m_128425_(DESTROY_BLOCKS, 99)) {
            this.destroyBlocks = tag.m_128471_(DESTROY_BLOCKS);
        }
        if (tag.m_128425_(EXPLODE_ON_CONTACT, 99)) {
            this.explodeOnContact = tag.m_128471_(EXPLODE_ON_CONTACT);
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
        JsonObject object = new JsonObject();
        object.addProperty("damage", (Number)Float.valueOf(this.damage));
        object.addProperty("radius", (Number)Float.valueOf(this.radius));
        object.addProperty(KNOCKBACK, (Number)Float.valueOf(this.knockback));
        object.addProperty("damageReduceOverDistance", Boolean.valueOf(this.damageReduceOverDistance));
        object.addProperty("causeFire", Boolean.valueOf(this.causeFire));
        object.addProperty("destroyBlocks", Boolean.valueOf(this.destroyBlocks));
        object.addProperty(EXPLODE_ON_CONTACT, Boolean.valueOf(this.explodeOnContact));
        return object;
    }

    public ExplosionConfig copy() {
        ExplosionConfig projectile = new ExplosionConfig();
        projectile.damage = this.damage;
        projectile.knockback = this.knockback;
        projectile.damageReduceOverDistance = this.damageReduceOverDistance;
        projectile.causeFire = this.causeFire;
        projectile.radius = this.radius;
        projectile.destroyBlocks = this.destroyBlocks;
        projectile.explodeOnContact = this.explodeOnContact;
        return projectile;
    }

    public float getDamage() {
        return this.damage;
    }

    public boolean isDamageReduceOverDistance() {
        return this.damageReduceOverDistance;
    }

    public boolean isCauseFire() {
        return this.causeFire;
    }

    public boolean isExplodeOnContact() {
        return this.explodeOnContact;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public float getRadius() {
        return this.radius;
    }

    public boolean isDestroyBlocks() {
        return this.destroyBlocks;
    }

    public static ExplosionConfig create(CompoundTag tag) {
        ExplosionConfig ammo = new ExplosionConfig();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Projectile");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final ExplosionConfig config;

        private Builder() {
            this.config = new ExplosionConfig();
        }

        private Builder(ExplosionConfig projectile) {
            this.config = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ExplosionConfig projectile) {
            return new Builder(projectile);
        }

        public ExplosionConfig build() {
            return this.config.copy();
        }

        public Builder setDamage(float damage) {
            this.config.damage = damage;
            return this;
        }

        public Builder setRadius(float value) {
            this.config.radius = value;
            return this;
        }

        public void setDamageReduceOverDistance(boolean damageReduceOverDistance) {
            this.config.damageReduceOverDistance = damageReduceOverDistance;
        }

        public void setCauseFire(boolean causeFire) {
            this.config.causeFire = causeFire;
        }

        public void setDestroyBlocks(boolean destroyBlocks) {
            this.config.destroyBlocks = destroyBlocks;
        }

        public void setExplodeOnContact(boolean explodeOnContact) {
            this.config.explodeOnContact = explodeOnContact;
        }

        public void setKnockback(float knockback) {
            this.config.knockback = knockback;
        }
    }
}

