/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.common.data.holders.ResourceHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class WeaponMode
extends ResourceHolder {
    private static final Map<ResourceLocation, WeaponMode> loadingTypeMap = new HashMap<ResourceLocation, WeaponMode>();
    public static final WeaponMode PRIMARY = new WeaponMode("primary", () -> WeaponMode.getAttackKey());
    public static final WeaponMode SECONDARY = new WeaponMode("secondary", () -> WeaponMode.getKeyUseKey());
    public static final WeaponMode ADDITIONAL = new WeaponMode("additional", () -> NtglKeyBinds.KEY_ADD_ATTACK);
    public static final WeaponMode ALTERNATIVE = new WeaponMode("alternative", () -> NtglKeyBinds.KEY_ALT_ATTACK);
    private final Supplier<KeyMapping> key;

    private WeaponMode(String id, Supplier<KeyMapping> key) {
        super(ResourceLocation.m_214293_((String)"ntgl", (String)id));
        this.key = key;
    }

    public WeaponMode(ResourceLocation id, Supplier<KeyMapping> key) {
        super(id);
        this.key = key;
    }

    public KeyMapping getKeyMapping() {
        return this.key.get();
    }

    public static void registerType(WeaponMode mode) {
        loadingTypeMap.putIfAbsent(mode.getId(), mode);
    }

    public static WeaponMode getType(ResourceLocation id) {
        return loadingTypeMap.getOrDefault(id, PRIMARY);
    }

    public static WeaponMode getType(String id) {
        return WeaponMode.getType(ResourceLocation.m_135820_((String)id));
    }

    private static KeyMapping getAttackKey() {
        return Minecraft.m_91087_().f_91066_.f_92096_;
    }

    private static KeyMapping getKeyUseKey() {
        return Minecraft.m_91087_().f_91066_.f_92095_;
    }

    static {
        WeaponMode.registerType(PRIMARY);
        WeaponMode.registerType(SECONDARY);
        WeaponMode.registerType(ADDITIONAL);
        WeaponMode.registerType(ALTERNATIVE);
    }
}

