/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity.throwable;

import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.util.interfaces.IConfigProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public abstract class ThrowableItemEntity<T extends Item>
extends ThrowableProjectile
implements IEntityAdditionalSpawnData {
    protected ProjectileConfig projectile;
    private ItemStack item = ItemStack.f_41583_;
    private boolean shouldBounce;
    private float gravityVelocity = 0.03f;
    public float rotation;
    public float prevRotation;
    private int maxLife = 200;

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ThrowableItemEntity(EntityType<? extends ThrowableItemEntity> entityType, Level world, LivingEntity thrower, T item) {
        super(entityType, thrower, world);
        this.projectile = ((WeaponConfig)((IConfigProvider)item).getConfig()).getThrowable().getProjectile();
        this.setItem(new ItemStack(item));
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        compound.m_128379_("shouldBounce", this.shouldBounce);
        compound.m_128350_("gravityVelocity", this.gravityVelocity);
    }

    protected void m_7378_(CompoundTag compound) {
        this.projectile = ProjectileConfig.create(compound.m_128469_("Projectile"));
        this.shouldBounce = compound.m_128471_("shouldBounce");
        this.gravityVelocity = compound.m_128457_("gravityVelocity");
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.m_130079_(this.projectile.serializeNBT());
        buffer.writeBoolean(this.shouldBounce);
        buffer.writeFloat(this.gravityVelocity);
        buffer.m_130055_(this.item);
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.projectile = ProjectileConfig.create(buffer.m_130260_());
        this.shouldBounce = buffer.readBoolean();
        this.gravityVelocity = buffer.readFloat();
        this.item = buffer.m_130267_();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.shouldBounce && this.f_19797_ >= this.maxLife) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    protected void m_6532_(HitResult result) {
        switch (result.m_6662_()) {
            case BLOCK: {
                this.m_8060_((BlockHitResult)result);
                break;
            }
            case ENTITY: {
                this.m_5790_((EntityHitResult)result);
                break;
            }
        }
    }

    protected void m_5790_(EntityHitResult result) {
        Entity entity = result.m_82443_();
        if (this.shouldBounce) {
            double speed = this.m_20184_().m_82553_();
            if (speed > 0.1) {
                float damage = this.getProjectileConfig().getDamage();
                entity.m_6469_(entity.m_269291_().m_269390_((Entity)this, this.m_19749_()), damage);
            }
            this.bounce(Direction.m_122366_((double)this.m_20184_().m_7096_(), (double)this.m_20184_().m_7098_(), (double)this.m_20184_().m_7094_()).m_122424_());
            this.m_20256_(this.m_20184_().m_82542_(0.25, 1.0, 0.25));
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        BlockPos resultPos = result.m_82425_();
        BlockState state = this.m_9236_().m_8055_(resultPos);
        if (this.shouldBounce) {
            SoundEvent event = state.m_60734_().getSoundType(state, (LevelReader)this.m_9236_(), resultPos, (Entity)this).m_56776_();
            double speed = this.m_20184_().m_82553_();
            if (speed > 0.1) {
                this.m_9236_().m_6263_(null, result.m_82450_().f_82479_, result.m_82450_().f_82480_, result.m_82450_().f_82481_, event, SoundSource.AMBIENT, 1.0f, 1.0f);
                this.m_9236_().m_214171_(GameEvent.f_157777_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
            }
            this.bounce(result.m_82434_());
        } else {
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.onDeath();
        }
    }

    protected float m_7139_() {
        return this.gravityVelocity;
    }

    public boolean m_20068_() {
        return !this.projectile.isGravity();
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public ProjectileConfig getProjectileConfig() {
        return this.projectile;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public void setMaxLife(int maxLife) {
        this.maxLife = maxLife;
    }

    protected void setShouldBounce(boolean shouldBounce) {
        this.shouldBounce = shouldBounce;
    }

    protected void setGravityVelocity(float gravity) {
        this.gravityVelocity = gravity;
    }

    public void onDeath() {
    }

    private void bounce(Direction direction) {
        switch (direction.m_122434_()) {
            case X: {
                this.m_20256_(this.m_20184_().m_82542_(-0.5, 0.75, 0.75));
                break;
            }
            case Y: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, -0.25, 0.75));
                if (!(this.m_20184_().m_7098_() < (double)this.m_7139_())) break;
                this.m_20256_(this.m_20184_().m_82542_(1.0, 0.0, 1.0));
                break;
            }
            case Z: {
                this.m_20256_(this.m_20184_().m_82542_(0.75, 0.75, -0.5));
            }
        }
    }
}

