/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.item;

import com.nukateam.geo.interfaces.DynamicGeoItem;
import com.nukateam.geo.render.DynamicGeoItemRenderer;
import com.nukateam.geo.render.ProxyItemRenderer;
import com.nukateam.ntgl.client.animators.WeaponAnimator;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.client.render.renderers.weapon.DefaultWeaponRendererGeo;
import com.nukateam.ntgl.client.render.renderers.weapon.DynamicWeaponRenderer;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.ExplosionConfig;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.ProjectileType;
import com.nukateam.ntgl.common.foundation.entity.throwable.ThrowableItemEntity;
import com.nukateam.ntgl.common.foundation.item.interfaces.IColored;
import com.nukateam.ntgl.common.foundation.item.interfaces.IMeta;
import com.nukateam.ntgl.common.foundation.item.interfaces.IThrowable;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import com.nukateam.ntgl.common.util.interfaces.IWeaponModifier;
import com.nukateam.ntgl.common.util.managers.ProjectileManager;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.SetUtils;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import com.nukateam.ntgl.modules.datapack.ConfigSupplier;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class WeaponItem
extends Item
implements DynamicGeoItem,
IWeapon,
IThrowable,
IColored,
IMeta {
    public static final String VARIANT = "variant";
    private final Lazy<ResourceLocation> id = Lazy.of(this::getRegistryName);
    private final WeakHashMap<CompoundTag, WeaponConfig> modifiedGunCache = new WeakHashMap();
    private final Lazy<DefaultWeaponRendererGeo> WEAPON_RENDERER = Lazy.of(() -> new DefaultWeaponRendererGeo());
    private WeaponConfig weaponConfig = new WeaponConfig();
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected IWeaponModifier[] modifiers;

    public WeaponItem(Item.Properties properties, IWeaponModifier ... modifiers) {
        super(properties);
        this.modifiers = modifiers;
    }

    @Override
    public IWeaponModifier[] getModifiers() {
        return this.modifiers;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public DynamicGeoItemRenderer getRenderer() {
        return (DynamicGeoItemRenderer)((Object)this.WEAPON_RENDERER.get());
    }

    public BiFunction<ItemDisplayContext, DynamicWeaponRenderer<WeaponAnimator>, WeaponAnimator> getAnimatorFactory() {
        return WeaponAnimator::new;
    }

    @Override
    public void setConfig(ConfigSupplier<WeaponConfig> supplier) {
        this.weaponConfig = supplier.config();
        this.weaponConfig.onCreated(this.getId().m_135815_());
    }

    @Override
    public WeaponConfig getConfig() {
        return this.weaponConfig;
    }

    @Override
    public ResourceLocation getId() {
        return (ResourceLocation)this.id.get();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private ProxyItemRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new ProxyItemRenderer(WeaponItem.this.getRenderer());
                }
                return this.renderer;
            }
        });
    }

    public static String getVariant(ItemStack stack) {
        CompoundTag tag = stack.m_41784_();
        if (!tag.m_128425_(VARIANT, 8)) {
            tag.m_128359_(VARIANT, "default");
        }
        return tag.m_128461_(VARIANT);
    }

    public void setDefaultTag(CompoundTag tag) {
        tag.m_128405_("AmmoCount", this.getConfig().getGeneral().getMaxAmmo());
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            ServerPlayer player;
            LivingEntity livingEntity = (LivingEntity)entity;
            CompoundTag tag = stack.m_41784_();
            WeaponData data = new WeaponData(stack, livingEntity);
            Set<AmmoHolder> ammoItems = WeaponModifierHelper.getAmmoItems(data);
            WeaponStateHelper.getCurrentAmmo(data);
            if (tag.m_128425_("Ammo", 8)) {
                String ammoId = tag.m_128461_("Ammo");
                boolean matches = ammoItems.stream().anyMatch(i -> i.getId().toString().equals(ammoId));
                if (!matches) {
                    if (entity instanceof ServerPlayer) {
                        player = (ServerPlayer)entity;
                        ServerPlayHandler.unloadGun(player, stack);
                    }
                    AmmoHolder firstAmmo = SetUtils.getFirst(ammoItems);
                    WeaponStateHelper.setCurrentAmmo(data, firstAmmo.getId());
                }
            }
            int maxAmmo = WeaponModifierHelper.getMaxAmmo(data);
            int currentAmount = WeaponStateHelper.getAmmoCount(data);
            if (currentAmount > maxAmmo && entity instanceof ServerPlayer) {
                player = (ServerPlayer)entity;
                ServerPlayHandler.unloadGun(player, stack);
            }
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flag) {
        WeaponData data = new WeaponData(stack, null);
        CompoundTag tagCompound = stack.m_41784_();
        WeaponItem.addAmmoType(tooltip, data);
        WeaponItem.addFireRate(tooltip, data);
        WeaponItem.addDamage(tooltip, tagCompound, data);
        WeaponItem.addMelleDamage(tooltip, data);
        ExplosionConfig explosion = WeaponStateHelper.getProjectileConfig(data).getExplosion();
        if (explosion.getRadius() > 0.0f) {
            WeaponItem.addExplosionTip(tooltip, explosion);
        }
        WeaponItem.addAmmo(tooltip, tagCompound, data);
        WeaponItem.addFuel(tooltip, data);
        Component name = NtglKeyBinds.KEY_ATTACHMENTS.getKey().m_84875_();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.attachment_help", (Object[])new Object[]{name}).m_130940_(ChatFormatting.YELLOW));
    }

    public static void addExplosionTip(List<Component> tooltip, ExplosionConfig explosion) {
        float damage = explosion.getDamage();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.explosionDamage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage)}).m_130940_(ChatFormatting.GRAY));
        float radius = explosion.getRadius();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.explosionRadius", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(radius)}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addAmmoType(List<Component> tooltip, WeaponData data) {
        String descriptionId = WeaponStateHelper.getCurrentAmmo(data).getDescriptionId();
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.ammo_type", (Object[])new Object[]{Component.m_237115_((String)descriptionId).m_130940_(ChatFormatting.WHITE)}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addFireRate(List<Component> tooltip, WeaponData data) {
        int rate = WeaponModifierHelper.getRate(data);
        rate = rate == 0 ? 0 : 20 / rate;
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.rate", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(rate)}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addFuel(List<Component> tooltip, WeaponData weaponData) {
        Set<AmmoHolder> allFuel = WeaponModifierHelper.getAllFuel(weaponData);
        for (AmmoHolder fuelType : allFuel) {
            int fuelAmount = FuelUtils.getFuel(weaponData.weapon, fuelType);
            Integer maxFuel = WeaponModifierHelper.getMaxFuel(fuelType.getId(), weaponData);
            tooltip.add((Component)Component.m_237115_((String)fuelType.getDescriptionId()).m_130946_(String.valueOf(ChatFormatting.WHITE) + " : " + fuelAmount + "/" + maxFuel).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void addAmmo(List<Component> tooltip, CompoundTag tagCompound, WeaponData weaponData) {
        if (tagCompound.m_128471_("IgnoreAmmo")) {
            tooltip.add((Component)Component.m_237115_((String)"info.ntgl.ignore_ammo").m_130940_(ChatFormatting.AQUA));
        } else {
            int ammoCount = tagCompound.m_128451_("AmmoCount");
            tooltip.add((Component)Component.m_237110_((String)"info.ntgl.ammo", (Object[])new Object[]{ChatFormatting.WHITE.toString() + ammoCount + "/" + WeaponModifierHelper.getMaxAmmo(weaponData)}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private static void addDamage(List<Component> tooltip, CompoundTag tagCompound, WeaponData weaponData) {
        float damage = WeaponStateHelper.getProjectileDamage(weaponData);
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.damage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage)}).m_130940_(ChatFormatting.GRAY));
    }

    private static void addMelleDamage(List<Component> tooltip, WeaponData weaponData) {
        float damage = WeaponModifierHelper.getMeleeDamage(weaponData);
        tooltip.add((Component)Component.m_237110_((String)"info.ntgl.melee_damage", (Object[])new Object[]{String.valueOf(ChatFormatting.WHITE) + ItemStack.f_41584_.format(damage)}).m_130940_(ChatFormatting.GRAY));
    }

    @Override
    public WeaponConfig getModifiedConfig(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41783_();
        if (tagCompound != null && tagCompound.m_128425_("Gun", 10)) {
            return this.modifiedGunCache.computeIfAbsent(tagCompound, item -> {
                if (tagCompound.m_128471_("Custom")) {
                    ResourceLocation key = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
                    return WeaponConfig.create(key, tagCompound.m_128469_("Gun"));
                }
                WeaponConfig gunCopy = this.weaponConfig.copy();
                gunCopy.deserializeNBT(tagCompound.m_128469_("Gun"));
                return gunCopy;
            });
        }
        return this.weaponConfig;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return this.weaponConfig.getGeneral().isEnchantable() && super.isBookEnchantable(stack, book);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    public boolean m_8120_(ItemStack stack) {
        return this.weaponConfig.getGeneral().isEnchantable() && this.getMaxStackSize(stack) == 1;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return this.weaponConfig.getGeneral().isEnchantable() ? 5 : 0;
    }

    public int m_6473_() {
        return this.weaponConfig.getGeneral().isEnchantable() ? 5 : 0;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    private ResourceLocation getRegistryName() {
        return ForgeRegistries.ITEMS.getKey((Object)this);
    }

    @Override
    public void expire(LivingEntity entityLiving) {
        ThrowableItemEntity throwableEntity = this.createThrowable(entityLiving.m_9236_(), entityLiving, 0);
        throwableEntity.onDeath();
    }

    @Override
    public void throwItem(ItemStack stack, LivingEntity entityLiving, int timeLeft) {
        Player player;
        Level level = entityLiving.m_9236_();
        if (!(entityLiving instanceof Player) || !(player = (Player)entityLiving).m_7500_()) {
            stack.m_41774_(1);
        }
        ThrowableItemEntity grenade = this.createThrowable(level, entityLiving, timeLeft);
        grenade.m_37251_((Entity)entityLiving, entityLiving.m_146909_(), entityLiving.m_146908_(), 0.0f, Math.min(1.0f, (float)timeLeft / 20.0f), 1.0f);
        level.m_7967_((Entity)grenade);
        this.onThrown(level, grenade);
        if (entityLiving instanceof Player) {
            ((Player)entityLiving).m_36246_(Stats.f_12982_.m_12902_((Object)this));
        }
    }

    protected void onThrown(Level world, ThrowableItemEntity entity) {
    }

    protected ThrowableItemEntity createThrowable(Level world, LivingEntity entity, int timeLeft) {
        ProjectileType projectile = this.getConfig().getThrowable().getProjectile().getProjectileType();
        return ProjectileManager.getInstance().getFactory(projectile).create(world, entity, this, timeLeft);
    }
}

