/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.network.KeyAction;
import com.nukateam.ntgl.common.network.ServerPlayHandler;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;

public class C2SMessageGrenade
extends PlayMessage<C2SMessageGrenade> {
    private KeyAction action;
    private InteractionHand hand = InteractionHand.MAIN_HAND;
    WeaponMode weaponMode;

    public C2SMessageGrenade() {
    }

    public C2SMessageGrenade(KeyAction reload, InteractionHand hand, WeaponMode weaponMode) {
        this.action = reload;
        this.hand = hand;
        this.weaponMode = weaponMode;
    }

    public void encode(C2SMessageGrenade message, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)message.action);
        buffer.m_130068_((Enum)message.hand);
        buffer.m_130070_(message.weaponMode.toString());
    }

    public C2SMessageGrenade decode(FriendlyByteBuf buffer) {
        return new C2SMessageGrenade((KeyAction)buffer.m_130066_(KeyAction.class), (InteractionHand)buffer.m_130066_(InteractionHand.class), WeaponMode.getType(buffer.m_130277_()));
    }

    public void handle(C2SMessageGrenade message, MessageContext supplier) {
        supplier.execute(() -> {
            ServerPlayer player = supplier.getPlayer();
            if (player != null && !player.m_5833_()) {
                ServerPlayHandler.handleGrenade(message, player);
            }
        });
        supplier.setHandled(true);
    }

    public KeyAction getAction() {
        return this.action;
    }

    public InteractionHand getHand() {
        return this.hand;
    }

    public WeaponMode getAttackMode() {
        return this.weaponMode;
    }
}

