/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.data.config.weapon.ExplosionConfig;
import com.nukateam.ntgl.common.network.BufferUtil;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class S2CMessageProjectileExplosion
extends PlayMessage<S2CMessageProjectileExplosion> {
    private Vec3 position;
    private Vec3 knockback;
    private ExplosionConfig config;
    private List<BlockPos> toBlow;

    public S2CMessageProjectileExplosion() {
    }

    public S2CMessageProjectileExplosion(Vec3 position, Vec3 knockback, ExplosionConfig config, List<BlockPos> toBlow) {
        this.position = position;
        this.knockback = Objects.requireNonNullElseGet(knockback, () -> new Vec3(0.0, 0.0, 0.0));
        if (knockback == null) {
            this.knockback = Vec3.f_82478_;
        }
        this.config = config;
        this.toBlow = toBlow;
    }

    public void encode(S2CMessageProjectileExplosion message, FriendlyByteBuf buffer) {
        BufferUtil.writeVec3(buffer, message.position);
        BufferUtil.writeVec3(buffer, message.knockback);
        buffer.m_130079_(message.config.serializeNBT());
        buffer.m_236828_(message.toBlow, (buf, blockPos) -> {
            int x = blockPos.m_123341_() - Mth.m_14107_((double)message.position.f_82479_);
            int y = blockPos.m_123342_() - Mth.m_14107_((double)message.position.f_82480_);
            int z = blockPos.m_123343_() - Mth.m_14107_((double)message.position.f_82481_);
            buf.writeByte(x);
            buf.writeByte(y);
            buf.writeByte(z);
        });
    }

    public S2CMessageProjectileExplosion decode(FriendlyByteBuf buffer) {
        this.position = BufferUtil.readVec3(buffer);
        this.knockback = BufferUtil.readVec3(buffer);
        this.config = ExplosionConfig.create(buffer.m_130260_());
        int x = Mth.m_14107_((double)this.position.f_82479_);
        int y = Mth.m_14107_((double)this.position.f_82480_);
        int z = Mth.m_14107_((double)this.position.f_82481_);
        this.toBlow = buffer.m_236845_(p_178850_ -> {
            int l = p_178850_.readByte() + x;
            int i1 = p_178850_.readByte() + y;
            int j1 = p_178850_.readByte() + z;
            return new BlockPos(l, i1, j1);
        });
        return new S2CMessageProjectileExplosion(this.position, this.knockback, this.config, this.toBlow);
    }

    public void handle(S2CMessageProjectileExplosion message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleMessageExplosion(message));
        supplier.setHandled(true);
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getKnockback() {
        return this.knockback;
    }

    public ExplosionConfig getConfig() {
        return this.config;
    }

    public List<BlockPos> getToBlow() {
        return this.toBlow;
    }
}

