/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.network.message;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.ntgl.client.handlers.ClientPlayHandler;
import com.nukateam.ntgl.common.util.util.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;

public class S2CMessageProjectileHitFluid
extends PlayMessage<S2CMessageProjectileHitFluid> {
    private Vec3 pos;
    float size;
    float speed;
    boolean isInLava;
    private int projectileId;

    public S2CMessageProjectileHitFluid() {
    }

    public S2CMessageProjectileHitFluid(Vec3 pos, float size, float speed, boolean isInLava, int projectileId) {
        this.pos = pos;
        this.size = size;
        this.speed = speed;
        this.isInLava = isInLava;
        this.projectileId = projectileId;
    }

    public void encode(S2CMessageProjectileHitFluid message, FriendlyByteBuf buffer) {
        buffer.m_130079_(NbtUtils.writeVec3(message.pos));
        buffer.writeFloat(message.size);
        buffer.writeFloat(message.speed);
        buffer.writeBoolean(message.isInLava);
        buffer.writeInt(message.projectileId);
    }

    public S2CMessageProjectileHitFluid decode(FriendlyByteBuf buffer) {
        Vec3 pos = NbtUtils.readVec3(buffer.m_130260_());
        return new S2CMessageProjectileHitFluid(pos, buffer.readFloat(), buffer.readFloat(), buffer.readBoolean(), buffer.readInt());
    }

    public void handle(S2CMessageProjectileHitFluid message, MessageContext supplier) {
        supplier.execute(() -> ClientPlayHandler.handleProjectileHitFluid(message));
        supplier.setHandled(true);
    }

    public Vec3 getPos() {
        return this.pos;
    }

    public float getSize() {
        return this.size;
    }

    public float getSpeed() {
        return this.speed;
    }

    public boolean isInLava() {
        return this.isInLava;
    }

    public int getProjectileId() {
        return this.projectileId;
    }
}

