/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.helpers.compatibility.backpack;

import com.nukateam.ntgl.Ntgl;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.util.helpers.compatibility.CuriosHelper;
import com.nukateam.ntgl.common.util.helpers.context.AmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.IAmmoContext;
import com.nukateam.ntgl.common.util.helpers.context.YyzBackpackAmmoContext;
import com.nukateam.ntgl.common.util.util.InventoryUtil;
import javax.annotation.Nullable;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackItem;

public class YyzBackpackHelper {
    public static IAmmoContext findAmmo(Player player, AmmoHolder id) {
        IItemHandler inventory = YyzBackpackHelper.getBackpackInventory(player);
        if (inventory == null) {
            return AmmoContext.NONE;
        }
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.isAmmo(stack, id)) continue;
            return new YyzBackpackAmmoContext(stack, inventory, i);
        }
        return AmmoContext.NONE;
    }

    public static IAmmoContext findMagazine(Player player, AmmoHolder id) {
        IItemHandler inventory = YyzBackpackHelper.getBackpackInventory(player);
        if (inventory == null) {
            return AmmoContext.NONE;
        }
        ItemStack ammo = null;
        int ammoSlot = -1;
        for (int i = 0; i < inventory.getSlots(); ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            if (!InventoryUtil.isAmmo(stack, id)) continue;
            if (stack.m_41773_() == 0) {
                return new YyzBackpackAmmoContext(stack, inventory, i);
            }
            if (ammo != null && (stack.m_41773_() >= ammo.m_41773_() || ammo.m_41773_() >= ammo.m_41776_())) continue;
            ammo = stack;
            ammoSlot = i;
        }
        return ammo == null ? AmmoContext.NONE : new YyzBackpackAmmoContext(ammo, inventory, ammoSlot);
    }

    @Nullable
    private static IItemHandler getBackpackInventory(Player player) {
        ItemStack backpackCurio;
        ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
        if (YyzBackpackHelper.isYyzBackpack(chestStack)) {
            LazyOptional backpackInventory = chestStack.getCapability(ForgeCapabilities.ITEM_HANDLER);
            return (IItemHandler)backpackInventory.orElse(null);
        }
        if (Ntgl.curiosLoaded && (backpackCurio = CuriosHelper.getItem(player, YyzBackpackHelper::isYyzBackpack)) != null) {
            LazyOptional backpackInventory = backpackCurio.getCapability(ForgeCapabilities.ITEM_HANDLER);
            return (IItemHandler)backpackInventory.orElse(null);
        }
        return null;
    }

    private static boolean isYyzBackpack(ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        return stack.m_41720_() instanceof BackpackItem;
    }
}

