/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.client.events;

import com.nukateam.chassis_core.client.ClientConfig;
import com.nukateam.chassis_core.client.utils.KeyUtils;
import com.nukateam.chassis_core.common.input.CommonInputHandler;
import com.nukateam.chassis_core.common.input.InputKey;
import com.nukateam.chassis_core.common.input.KeyAction;
import com.nukateam.chassis_core.common.network.PacketSender;
import com.nukateam.chassis_core.common.network.actions.InputAction;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class InputEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        KeyAction action;
        if (InputEvents.isNotInGame()) {
            return;
        }
        if (event.getAction() == 1) {
            action = KeyAction.PRESS;
            if (event.getKey() == NtglKeyBinds.LEAVE.getKey().m_84873_()) {
                PlayerUtils.stopWearingArmor((Player)Minecraft.m_91087_().f_91074_);
            }
        } else {
            action = event.getAction() == 0 ? KeyAction.RELEASE : KeyAction.REPEAT;
        }
        InputEvents.handleInput(event.getKey(), action);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onMouseKeyInput(InputEvent.MouseButton event) {
        switch (event.getAction()) {
            case 1: {
                break;
            }
            case 0: {
                if (event.getButton() != ClientConfig.OPTIONS.f_92095_.getKey().m_84873_() && InputEvents.isNotInGame()) {
                    return;
                }
                InputEvents.handleInput(event.getButton(), KeyAction.RELEASE);
            }
        }
    }

    public static void onDoubleClick(InputEvent.Key event) {
        if (InputEvents.isNotInGame()) {
            return;
        }
        InputEvents.handleInput(event.getKey(), KeyAction.DOUBLE_CLICK);
    }

    public static void onLongClick(int key, int ticks) {
        if (InputEvents.isNotInGame()) {
            return;
        }
        InputEvents.handleInput(key, KeyAction.LONG_PRESS);
    }

    public static void onLongRelease(int key, int ticks) {
    }

    private static void handleInput(int key, KeyAction action) {
        InputKey inputKey = KeyUtils.getByKey(key);
        if (PlayerUtils.getLocalPlayer() == null || inputKey == null) {
            return;
        }
        PacketSender.doServerAction(new InputAction(inputKey, action), -1);
        CommonInputHandler.onKeyInput(inputKey, action, (Player)PlayerUtils.getLocalPlayer());
    }

    public static boolean isNotInGame() {
        return Minecraft.m_91087_().f_91080_ != null;
    }
}

