/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.config;

import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.modules.config.annotation.Ignored;
import com.nukateam.chassis_core.modules.config.utils.NbtUtils;
import java.util.LinkedHashSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraftforge.common.util.INBTSerializable;

public class ChassisConfig
implements INBTSerializable<CompoundTag> {
    @Ignored
    private LinkedHashSet<ChassisPart> parts;

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("parts", (Tag)NbtUtils.serializeSet(this.parts));
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("parts", 10)) {
            this.parts = NbtUtils.deserializeSet(tag.m_128469_("parts"), ChassisPart::getType);
        }
    }

    public ChassisConfig copy() {
        ChassisConfig config = new ChassisConfig();
        config.parts = this.parts;
        return config;
    }

    public static ChassisConfig create(CompoundTag tag) {
        ChassisConfig config = new ChassisConfig();
        config.deserializeNBT(tag);
        return config;
    }

    public LinkedHashSet<ChassisPart> getParts() {
        return this.parts;
    }

    public static class Builder {
        private final ChassisConfig config;

        private Builder() {
            this.config = new ChassisConfig();
        }

        private Builder(ChassisConfig projectile) {
            this.config = projectile.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(ChassisConfig projectile) {
            return new Builder(projectile);
        }

        public ChassisConfig build() {
            return this.config.copy();
        }

        public Builder setParts(LinkedHashSet<ChassisPart> parts) {
            this.config.parts = parts;
            return this;
        }
    }
}

