/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.container.menu;

import com.nukateam.chassis_core.ChassisCore;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.container.slot.EquipmentSlot;
import com.nukateam.chassis_core.common.foundation.entity.Chassis;
import com.nukateam.chassis_core.common.util.Pos2I;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public abstract class ChassisMenu
extends AbstractContainerMenu {
    private static final int SLOT_SIZE = 18;
    private static final int INVENTORY_POS_X = 8;
    private static final int HOTBAR_POS_X = 8;
    private static final int INVENTORY_ROW_SIZE = 9;
    protected final int inventoryPosY;
    protected final int hotbarPosY;
    protected final Container container;
    protected final Chassis chassis;
    protected int size;

    public ChassisMenu(MenuType<?> pMenuType, int containerId, Inventory playerInventory, FriendlyByteBuf buf, int inventoryPosY) {
        this(pMenuType, containerId, (Container)new SimpleContainer(256), playerInventory, (Chassis)Minecraft.m_91087_().f_91073_.m_6815_(buf.readInt()), inventoryPosY);
    }

    public ChassisMenu(MenuType<?> pMenuType, int containerId, Container container, Inventory playerInventory, Chassis entity, int inventoryPosY) {
        super(pMenuType, containerId);
        this.chassis = entity;
        this.container = container;
        this.container.m_5856_(playerInventory.f_35978_);
        this.inventoryPosY = inventoryPosY;
        this.hotbarPosY = inventoryPosY + 58;
        this.size = container.m_6643_();
        this.addPlayerInventory(playerInventory);
        this.addPlayerHotbar(playerInventory);
    }

    public boolean m_6875_(Player playerIn) {
        return this.container.m_6542_(playerIn) && this.chassis.m_6084_() && this.chassis.m_20270_((Entity)playerIn) < 8.0f;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        try {
            Slot sourceSlot = (Slot)this.f_38839_.get(index);
            if (!sourceSlot.m_6657_()) {
                return ItemStack.f_41583_;
            }
            ItemStack sourceStack = sourceSlot.m_7993_();
            ItemStack copyOfSourceStack = sourceStack.m_41777_();
            if (index < 36) {
                if (!this.m_38903_(sourceStack, 36, 36 + this.size, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 36 + this.size) {
                if (!this.m_38903_(sourceStack, 0, 36, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                System.out.println("Invalid slotIndex:" + index);
                return ItemStack.f_41583_;
            }
            if (sourceStack.m_41613_() == 0) {
                sourceSlot.m_5852_(ItemStack.f_41583_);
            } else {
                sourceSlot.m_6654_();
            }
            sourceSlot.m_142406_(playerIn, sourceStack);
            return copyOfSourceStack;
        }
        catch (Exception ignored) {
            return ItemStack.f_41583_;
        }
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.container.m_5785_(playerIn);
    }

    public Chassis getChassis() {
        return this.chassis;
    }

    @Nullable
    protected Integer getId(ChassisPart chassisPart) {
        return this.chassis.getPartId(chassisPart);
    }

    protected void createSlot(ChassisPart chassisPart, Pos2I pos) {
        try {
            Integer id = this.getId(chassisPart);
            if (id != null) {
                this.m_38897_(new EquipmentSlot(chassisPart, this.container, this.getId(chassisPart), pos.x, pos.y));
            }
        }
        catch (Exception e) {
            ChassisCore.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int slot = 0; slot < 9; ++slot) {
                this.m_38897_(new Slot((Container)playerInventory, slot + row * 9 + 9, 8 + slot * 18, this.inventoryPosY + row * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int slot = 0; slot < 9; ++slot) {
            this.m_38897_(new Slot((Container)playerInventory, slot, 8 + slot * 18, this.hotbarPosY));
        }
    }

    @Nullable
    private static Chassis getChassis(FriendlyByteBuf buf) {
        return (Chassis)Minecraft.m_91087_().f_91073_.m_6815_(buf.readInt());
    }
}

