/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.foundation.item;

import com.nukateam.chassis_core.client.render.utils.ResourceHelper;
import com.nukateam.chassis_core.common.config.EquipmentConfig;
import com.nukateam.chassis_core.common.data.holders.ChassisPart;
import com.nukateam.chassis_core.common.foundation.item.IChassisEquipment;
import com.nukateam.chassis_core.common.foundation.item.StackUtils;
import com.nukateam.chassis_core.common.network.managers.ConfigSupplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class ChassisEquipment
extends Item
implements IChassisEquipment,
GeoItem {
    public final ChassisPart part;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final Lazy<String> name = Lazy.of(() -> ResourceHelper.getResourceName(ForgeRegistries.ITEMS.getKey((Object)this)));
    private EquipmentConfig config = new EquipmentConfig();

    public ChassisEquipment(Item.Properties pProperties, ChassisPart part) {
        super(pProperties);
        this.part = part;
    }

    @Nullable
    public ResourceLocation getTexture(ItemStack stack) {
        String variant = StackUtils.getVariant(stack);
        ResourceLocation value = this.getConfig().getTexture(variant);
        return value != null ? value : this.getConfig().getTexture("default");
    }

    @Override
    @Nullable
    public EquipmentConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ConfigSupplier<EquipmentConfig> config) {
        this.config = config.getConfig();
    }

    public String getName() {
        return (String)this.name.get();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

