/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.network.packet;

import com.mrcrayfish.framework.api.network.MessageContext;
import com.mrcrayfish.framework.api.network.message.PlayMessage;
import com.nukateam.chassis_core.common.data.enums.ActionType;
import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class C2SActionPacket
extends PlayMessage<C2SActionPacket> {
    ActionType action = null;

    public C2SActionPacket(ActionType action) {
        this.action = action;
    }

    public C2SActionPacket() {
    }

    public void encode(C2SActionPacket actionPacket, FriendlyByteBuf buffer) {
        buffer.writeByte(actionPacket.action.getId());
    }

    public C2SActionPacket decode(FriendlyByteBuf buffer) {
        ActionType action = ActionType.getById(buffer.readByte());
        return new C2SActionPacket(action);
    }

    public void handle(C2SActionPacket message, MessageContext supplier) {
        supplier.execute(() -> {
            ServerPlayer player = supplier.getPlayer();
            if (!PlayerUtils.isWearingChassis((Entity)player)) {
                return;
            }
            WearableChassis armor = (WearableChassis)player.m_20202_();
            switch (message.action) {
                case DISMOUNT: {
                    armor.exitArmor();
                    break;
                }
                case OPEN_GUI: {
                    armor.openGUI((Player)player);
                }
            }
        });
        supplier.setHandled(true);
    }
}

