/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.chassis_core.common.util.helpers;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityHelper {
    public static final String ENTITY_TAG = "EntityTag";
    public static final String CHASSIS_ENTITY_ID = "ItemEntityID";
    public static final String ENTITY_UUID = "EntityUUID";

    public static void giveEntityItemToPlayer(Player player, ItemStack stack, LivingEntity target) {
        if (!player.m_9236_().f_46443_) {
            ItemStack entityInItem = EntityHelper.entityToItem(stack, target);
            player.m_150109_().m_36054_(entityInItem);
        }
    }

    @NotNull
    public static ItemStack entityToItem(ItemStack stack, LivingEntity target) {
        CompoundTag newTag = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        target.m_20223_(entityTag);
        newTag.m_128365_(ENTITY_TAG, (Tag)entityTag);
        newTag.m_128359_(CHASSIS_ENTITY_ID, ForgeRegistries.ENTITY_TYPES.getKey((Object)target.m_6095_()).toString());
        stack.m_41751_(newTag);
        target.m_142687_(Entity.RemovalReason.DISCARDED);
        return stack;
    }

    @Nullable
    public static Entity entityFromItem(ItemStack stack, Level world) {
        String id;
        EntityType type;
        if (stack.m_41783_() != null && !stack.m_41783_().m_128461_(CHASSIS_ENTITY_ID).isEmpty() && (type = (EntityType)EntityType.m_20632_((String)(id = stack.m_41783_().m_128461_(CHASSIS_ENTITY_ID))).orElse(null)) != null) {
            Entity entity = type.m_20615_(world);
            if (entity == null) {
                return null;
            }
            entity.m_20258_(stack.m_41783_().m_128469_(ENTITY_TAG));
            if (stack.m_41783_().m_128441_(ENTITY_UUID)) {
                entity.m_20084_(stack.m_41783_().m_128342_(ENTITY_UUID));
            }
            return entity;
        }
        return null;
    }

    public static void clearItemTags(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        tag.m_128473_(CHASSIS_ENTITY_ID);
        tag.m_128473_(ENTITY_TAG);
        tag.m_128473_(ENTITY_UUID);
        stack.m_41751_(tag);
    }
}

