/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.geo.render;

import com.nukateam.geo.interfaces.IItemAnimator;
import com.nukateam.geo.interfaces.IResourceProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

public abstract class ItemAnimator
implements GeoEntity,
IItemAnimator,
IResourceProvider {
    protected final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final ItemDisplayContext transformType;
    protected ItemStack itemStack;
    private final Lazy<ResourceLocation> id = Lazy.of(this::crateId);

    public ItemAnimator(ItemDisplayContext transformType) {
        this.transformType = transformType;
    }

    @Override
    public ItemStack getStack() {
        return this.itemStack;
    }

    @Override
    public void setStack(ItemStack stack) {
        this.itemStack = stack;
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    public ItemDisplayContext getTransformType() {
        return this.transformType;
    }

    @Override
    public ResourceLocation getId() {
        return (ResourceLocation)this.id.get();
    }

    private ResourceLocation crateId() {
        Item item = this.getStack().m_41720_();
        if (item instanceof IResourceProvider) {
            IResourceProvider provider = (IResourceProvider)item;
            return provider.getId();
        }
        return ItemAnimator.getRegistryKey(item);
    }

    @Nullable
    private static ResourceLocation getRegistryKey(Item item) {
        return ForgeRegistries.ITEMS.getKey((Object)item);
    }
}

