/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.render.hud;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.ntgl.client.event.GunHudEvent;
import com.nukateam.ntgl.client.input.NtglKeyBinds;
import com.nukateam.ntgl.client.input.WeaponModeBindings;
import com.nukateam.ntgl.client.render.hud.cache.GunHudCache;
import com.nukateam.ntgl.client.settings.NtglOptions;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.helpers.KeyIcons;
import com.nukateam.ntgl.client.util.helpers.RgbHelper;
import com.nukateam.ntgl.client.util.helpers.render.Figures;
import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.data.config.weapon.Fuel;
import com.nukateam.ntgl.common.data.config.weapon.WeaponConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AmmoType;
import com.nukateam.ntgl.common.data.holders.CounterType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import com.nukateam.ntgl.common.data.holders.ThrowMode;
import com.nukateam.ntgl.common.data.holders.WeaponAction;
import com.nukateam.ntgl.common.data.holders.WeaponMode;
import com.nukateam.ntgl.common.foundation.item.interfaces.IWeapon;
import com.nukateam.ntgl.common.util.util.FuelUtils;
import com.nukateam.ntgl.common.util.util.ThrowableStateHelper;
import com.nukateam.ntgl.common.util.util.WeaponModifierHelper;
import com.nukateam.ntgl.common.util.util.WeaponStateHelper;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public class WeaponHud
implements IGuiOverlay {
    public static final float COUNTER_SCALE = 0.9f;
    public static final float BINDING_SCALE = 0.6f;
    public static final float WEAPON_MODE_SCALE = 0.7f;
    public static final int INVENTORY_AMMO_COUNT_COLOR = 0xAAAAAA;
    public static final int DEFAULT_AMMO_COLOR = 0xFFFFFF;
    public static final int LOW_AMMO_COLOR = 0xFF5555;
    public static final Colors DEFAULT_COLORS = new Colors(0xFFFFFF, 0xAAAAAA, 0xFFFFFF, 0xFF5555);
    protected static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    protected static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    protected static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static final int ICON_X = 115;
    private static final int OFFHAND_X_OFFSET = 110;
    private static final int BAR_WIDTH = 35;
    private static final int BAR_HEIGHT = 6;
    public static final int COUNTER_POS_X = 70;
    public static final int ICON_SIZE = 16;
    public static final int COUNTER_POS_Y = 36;
    private static final int BAR_START_X = 70;
    private static final int BAR_START_Y = 57;
    protected static final Map<InteractionHand, GunHudCache> cache = Map.of(InteractionHand.MAIN_HAND, new GunHudCache(InteractionHand.MAIN_HAND), InteractionHand.OFF_HAND, new GunHudCache(InteractionHand.OFF_HAND));
    public static final int INVENTORY_AMMO_POS_Y = 25;
    protected final Minecraft minecraft = Minecraft.m_91087_();
    private Colors colors = DEFAULT_COLORS;
    public static final IGuiOverlay AMMO_HUD = new WeaponHud();

    public void render(ForgeGui gui, GuiGraphics graphics, float partialTick, int width, int height) {
        if (this.minecraft.f_91074_ == null) {
            return;
        }
        LocalPlayer player = this.minecraft.f_91074_;
        WeaponHud.cache.forEach((hand, cache) -> {
            int x;
            ItemStack heldItem = player.m_21120_(hand);
            int n = x = hand == InteractionHand.OFF_HAND ? 110 : width;
            if (heldItem.m_41720_() instanceof IWeapon && WeaponHud.shouldRender(hand, player)) {
                this.updateCache((GunHudCache)cache, player, heldItem);
                if (!MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.START))) {
                    this.renderAmmoCounter(graphics, (GunHudCache)cache, heldItem, x, height);
                    MinecraftForge.EVENT_BUS.post((Event)new GunHudEvent(this, (InteractionHand)hand, graphics, (GunHudCache)cache, GunHudEvent.Phase.END));
                }
            }
        });
    }

    public void setHudColor(Colors hudColor) {
        this.colors = hudColor;
    }

    public void resetHudColor() {
        this.colors = DEFAULT_COLORS;
    }

    protected void renderAmmoCounter(GuiGraphics graphics, GunHudCache handCache, ItemStack stack, int x, int y) {
        if (!WeaponModifierHelper.shouldRenderHud(new WeaponData(stack, (LivingEntity)this.minecraft.f_91074_))) {
            return;
        }
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        Objects.requireNonNull(this.minecraft.f_91062_);
        int fontHeight = 9;
        this.renderAmmoTypeIcon(graphics, poseStack, handCache, x - 70 - 16 - 2, y - 36 - 11);
        this.renderCurrentAmmo(graphics, poseStack, handCache, x - 70, y - 36 - fontHeight);
        Figures.drawLine(graphics, x - 70, y - 31, 27, 2, RgbHelper.toRgba(this.colors.hud));
        if (handCache.isThrowable) {
            this.renderThrowModeIcon(graphics, poseStack, handCache, x - 70 - 16 - 2, y - 25 - 6);
        } else {
            this.renderFireModeIcon(graphics, poseStack, handCache, x - 70 - 16 - 2, y - 25 - 6);
        }
        this.renderInventoryAmmo(graphics, poseStack, handCache, x - 70 + 3, y - 25);
        this.renderFuelCounters(graphics, handCache, stack, x - 70 + 8, y - 57 - 3);
        this.renderWeaponModes(graphics, poseStack, handCache, x - 70 + 38, y - 25 - 2);
        poseStack.m_85849_();
    }

    protected void renderCurrentAmmo(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        String currentAmmoCountText = "";
        if (handCache.ammoConfig.getCounter() == CounterType.NUMBER) {
            currentAmmoCountText = CURRENT_AMMO_FORMAT.format(handCache.ammoCount);
            this.renderCounter(graphics, handCache, x, y, poseStack, currentAmmoCountText);
        } else if (handCache.ammoConfig.getCounter() == CounterType.PERCENT) {
            float percent = (float)handCache.ammoCount / (float)handCache.maxAmmoCount;
            currentAmmoCountText = CURRENT_AMMO_FORMAT_PERCENT.format(percent);
            this.renderCounter(graphics, handCache, x, y, poseStack, currentAmmoCountText);
        } else if (handCache.ammoConfig.getCounter() == CounterType.BAR) {
            float percent = (float)handCache.ammoCount / (float)handCache.maxAmmoCount;
            this.renderBarCounter(graphics, percent, x, y);
        }
    }

    protected void renderFuelCounters(GuiGraphics graphics, GunHudCache handCache, ItemStack stack, int x, int y) {
        int barOffsetY = 0;
        for (Map.Entry<AmmoHolder, Fuel> entry : handCache.fuels.entrySet()) {
            WeaponData gunData = new WeaponData(stack, (LivingEntity)this.minecraft.f_91074_);
            float fuelPercent = FuelUtils.getFuelPercent(stack, entry.getKey(), gunData);
            this.renderIcon(graphics, entry.getValue().getAmmo().getAmmoType().getIcon(), x - 16 - 2, y - 5 - barOffsetY);
            this.renderBarCounter(graphics, fuelPercent, x, y - barOffsetY);
            barOffsetY += 16;
        }
    }

    private void renderCounter(GuiGraphics graphics, GunHudCache handCache, int x, int y, PoseStack poseStack, String currentAmmoCountText) {
        int ammoCountColor = (double)handCache.ammoCount < (double)handCache.maxAmmoCount * 0.25 ? this.colors.lowAmmo : this.colors.currentAmmo;
        poseStack.m_85836_();
        float scale = 1.5f;
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.drawString(this.minecraft.f_91062_, currentAmmoCountText, (float)x / scale, (float)y / scale, ammoCountColor, true);
        poseStack.m_85849_();
    }

    protected void renderBarCounter(GuiGraphics graphics, float percent, int x, int y) {
        int color = (double)percent < 0.25 ? this.colors.lowAmmo : this.colors.currentAmmo;
        Figures.drawBar(graphics, x, y, 35, 6, percent, RgbHelper.toRgba(color));
    }

    protected void renderInventoryAmmo(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        String inventoryAmmoCountText = INVENTORY_AMMO_FORMAT.format(handCache.inventoryAmmoCount);
        poseStack.m_85836_();
        poseStack.m_85841_(0.9f, 0.9f, 1.0f);
        graphics.drawString(this.minecraft.f_91062_, inventoryAmmoCountText, (float)x / 0.9f, (float)y / 0.9f, this.colors.inventoryAmmo, true);
        poseStack.m_85849_();
    }

    protected void renderWeaponModes(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        int iconPosY = y;
        for (Map.Entry<WeaponMode, WeaponAction> entry : handCache.weaponModes.entrySet()) {
            WeaponMode mode = entry.getKey();
            WeaponAction action = entry.getValue();
            this.renderIcon(graphics, poseStack, action.getIcon(), x, iconPosY, 0.7f);
            this.renderKey(graphics, poseStack, WeaponModeBindings.getKey(mode).getKey(), x + 16, iconPosY + 3, false);
            iconPosY -= 12;
        }
    }

    protected void renderAmmoTypeIcon(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        AmmoType ammoType = handCache.ammoConfig.getAmmoType();
        ResourceLocation icon = ammoType.getIcon();
        this.renderIcon(graphics, icon, x, y);
        if (handCache.ammoTypeKey) {
            this.renderKey(graphics, poseStack, NtglKeyBinds.KEY_AMMO_SELECT.getKey(), x - 6, y + 6);
        }
    }

    protected void renderThrowModeIcon(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        ThrowMode mode = handCache.throwMode;
        ResourceLocation icon = mode.getIcon();
        this.renderIcon(graphics, icon, x, y);
        if (handCache.fireModeKey) {
            this.renderKey(graphics, poseStack, NtglKeyBinds.KEY_FIRE_SELECT.getKey(), x - 6, y + 6);
        }
    }

    protected void renderFireModeIcon(GuiGraphics graphics, PoseStack poseStack, GunHudCache handCache, int x, int y) {
        FireMode fireMode = handCache.fireMode;
        ResourceLocation icon = fireMode.getIcon();
        this.renderIcon(graphics, icon, x, y);
        if (handCache.fireModeKey) {
            this.renderKey(graphics, poseStack, NtglKeyBinds.KEY_FIRE_SELECT.getKey(), x - 6, y + 6);
        }
    }

    protected void renderKey(GuiGraphics graphics, PoseStack poseStack, InputConstants.Key key, int x, int y) {
        this.renderKey(graphics, poseStack, key, x, y, true);
    }

    protected void renderKey(GuiGraphics graphics, PoseStack poseStack, InputConstants.Key key, int x, int y, boolean isLeft) {
        if (!NtglOptions.getInstance().isShowTips()) {
            return;
        }
        ResourceLocation icon = KeyIcons.getIcon(key.m_84873_());
        if (icon != null) {
            this.renderIcon(graphics, poseStack, icon, x - 5, y - 3, 0.7f);
        } else {
            int side = isLeft ? 1 : -1;
            this.renderKeyName(graphics, poseStack, key, x + 3 * side - ClientDebug.X, y, 0.6f, isLeft);
        }
    }

    private void renderKeyName(GuiGraphics graphics, PoseStack poseStack, InputConstants.Key key, int x, int y, float scale, boolean isLeft) {
        FormattedCharSequence name = key.m_84875_().m_7532_();
        poseStack.m_85836_();
        int side = isLeft ? -1 : 0;
        int textOffset = this.minecraft.f_91062_.m_92724_(name) / 2 * side;
        poseStack.m_85841_(scale, scale, 1.0f);
        graphics.drawString(this.minecraft.f_91062_, name, (float)(x + textOffset) / scale, (float)y / scale, this.colors.inventoryAmmo, true);
        poseStack.m_85849_();
    }

    protected void renderIcon(GuiGraphics graphics, PoseStack poseStack, ResourceLocation icon, int x, int y, float scale) {
        poseStack.m_85836_();
        poseStack.m_85841_(scale, scale, 1.0f);
        this.renderIcon(graphics, icon, (int)((float)x / scale), (int)((float)y / scale));
        poseStack.m_85849_();
    }

    protected void renderIcon(GuiGraphics graphics, ResourceLocation icon, int x, int y) {
        float[] iconColor = RgbHelper.rgbToFloatRgba(this.colors.hud);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
        RenderSystem.setShaderColor((float)iconColor[0], (float)iconColor[1], (float)iconColor[2], (float)iconColor[3]);
        graphics.m_280163_(icon, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    protected WeaponConfig getConfig(ItemStack stack) {
        IWeapon weapon = (IWeapon)stack.m_41720_();
        return weapon.getModifiedConfig(stack);
    }

    protected void updateCache(GunHudCache handCache, LocalPlayer player, ItemStack weapon) {
        if (System.currentTimeMillis() - handCache.checkAmmoTimestamp > 200L) {
            WeaponData data = new WeaponData(weapon, (LivingEntity)player);
            handCache.checkAmmoTimestamp = System.currentTimeMillis();
            handCache.maxAmmoCount = WeaponModifierHelper.getMaxAmmo(data);
            handCache.fireMode = WeaponStateHelper.getFireMode(data);
            handCache.isThrowable = WeaponModifierHelper.getWeaponAction(data) == WeaponAction.THROW;
            handCache.weaponModes = new LinkedHashMap();
            Set<WeaponMode> weaponModes = WeaponModifierHelper.getWeaponModes(data).keySet();
            WeaponHud.addAction(handCache, WeaponMode.PRIMARY, data);
            for (WeaponMode mode : weaponModes) {
                WeaponHud.addAction(handCache, mode, data);
            }
            if (handCache.isThrowable) {
                handCache.throwMode = ThrowableStateHelper.getThrowMode(data);
                handCache.ammoCount = weapon.m_41613_();
                handCache.ammoConfig = WeaponModifierHelper.getConfig(data).getThrowable().getAmmo();
                handCache.fireModeKey = WeaponModifierHelper.getThrowModes(data).size() > 1;
            } else {
                handCache.ammoCount = WeaponStateHelper.getAmmoCount(data);
                handCache.ammoConfig = WeaponModifierHelper.getConfig(data).getAmmoConfig(WeaponStateHelper.getCurrentAmmo(data).getId());
                handCache.fireModeKey = WeaponModifierHelper.getFireModes(data).size() > 1;
                handCache.ammoTypeKey = WeaponModifierHelper.getAmmoItems(data).size() > 1;
            }
            Set<AmmoHolder> fuels = WeaponModifierHelper.getAllFuel(data);
            handCache.fuels.clear();
            for (AmmoHolder id : fuels) {
                Fuel value = WeaponModifierHelper.getFuel(id.getId(), data);
                handCache.fuels.put(id, value);
            }
            handCache.inventoryAmmoCount = !player.m_7500_() ? (handCache.isThrowable ? this.getInventoryThrowableCount(weapon, player.m_150109_()) : this.getInventoryAmmoCount(weapon, player.m_150109_())) : 9999;
        }
    }

    private static void addAction(GunHudCache handCache, WeaponMode mode, WeaponData data) {
        WeaponAction action = WeaponModifierHelper.getWeaponAction(data.clone().setWeaponMode(mode));
        if (action != WeaponAction.NONE) {
            handCache.weaponModes.put(mode, action);
        }
    }

    protected int getInventoryAmmoCount(ItemStack weapon, Inventory inventory) {
        int inventoryAmmoCount = 0;
        WeaponData gunData = new WeaponData(weapon, (LivingEntity)this.minecraft.f_91074_);
        AmmoHolder ammoHolder = WeaponStateHelper.getCurrentAmmo(gunData);
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            if (!ammoHolder.isAcceptable(inventoryStack)) continue;
            inventoryAmmoCount += inventoryStack.m_41613_() * ammoHolder.getValue(inventoryStack);
        }
        return inventoryAmmoCount;
    }

    protected int getInventoryThrowableCount(ItemStack stack, Inventory inventory) {
        int inventoryAmmoCount = 0;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack inventoryStack = inventory.m_8020_(i);
            Item inventoryItem = inventoryStack.m_41720_();
            if (inventoryItem != stack.m_41720_() || inventoryStack == stack) continue;
            inventoryAmmoCount += inventoryStack.m_41613_();
        }
        return inventoryAmmoCount;
    }

    private static boolean shouldRender(InteractionHand hand, LocalPlayer player) {
        return hand == InteractionHand.MAIN_HAND || WeaponModifierHelper.canUseOffhandWeapon((LivingEntity)player);
    }

    public record Colors(int hud, int inventoryAmmo, int currentAmmo, int lowAmmo) {
    }
}

