/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.helpers.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.nukateam.ntgl.common.util.data.Rgba;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RenderUtils {
    public static final float BEAM_ALPHA = 0.7f;

    public static void renderBeam(PoseStack poseStack, MultiBufferSource pBufferSource, ResourceLocation pBeamLocation, float pPartialTick, float pTextureScale, long gameTime, float pYOffset, float pHeight, Rgba pColors, float pBeamRadius, float pGlowRadius) {
        float maxY = pYOffset + pHeight;
        float f = (float)Math.floorMod(gameTime, 40) + pPartialTick;
        float f1 = pHeight < 0.0f ? f : -f;
        float f2 = Mth.m_14187_((float)(f1 * 0.2f - (float)Mth.m_14143_((float)(f1 * 0.1f))));
        float minX = -pGlowRadius;
        float maxX = -pGlowRadius;
        float minZ = -pGlowRadius;
        float maxZ = -pBeamRadius;
        float v = -1.0f + f2;
        float u = pHeight * pTextureScale * (0.7f / pBeamRadius) + v;
        poseStack.m_85836_();
        poseStack.m_85836_();
        VertexConsumer vertexConsumer = pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)false));
        RenderUtils.renderPart(poseStack, vertexConsumer, pColors.setAlpha(1.0f), pYOffset, maxY, 0.0f, pBeamRadius, pBeamRadius, 0.0f, maxZ, 0.0f, 0.0f, -pBeamRadius, u, v);
        poseStack.m_85849_();
        maxZ = -pGlowRadius;
        v = -1.0f + f2;
        u = pHeight * pTextureScale + v;
        RenderUtils.renderPart(poseStack, pBufferSource.m_6299_(RenderType.m_110460_((ResourceLocation)pBeamLocation, (boolean)true)), pColors.setAlpha(0.7f), pYOffset, maxY, minX, maxX, pGlowRadius, minZ, maxZ, pGlowRadius, pGlowRadius, pGlowRadius, u, v);
        poseStack.m_85849_();
    }

    public static void renderPart(PoseStack poseStack, VertexConsumer pConsumer, Rgba pColors, float pMinY, float pMaxY, float minX, float maxX, float minZ, float maxZ, float pX2, float pZ2, float pX3, float pZ3, float u, float v) {
        PoseStack.Pose pose = poseStack.m_85850_();
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        float red = pColors.r();
        float green = pColors.g();
        float blue = pColors.b();
        float alpha = pColors.a();
        RenderUtils.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, minX, maxX, minZ, maxZ, u, v);
        RenderUtils.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, pX3, pZ3, pX2, pZ2, u, v);
        RenderUtils.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, minZ, maxZ, pX3, pZ3, u, v);
        RenderUtils.renderQuad(matrix4f, matrix3f, pConsumer, red, green, blue, alpha, pMinY, pMaxY, pX2, pZ2, minX, maxX, u, v);
    }

    public static void renderQuad(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinV, float pMaxV) {
        RenderUtils.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMinX, pMinZ, 1.0f, pMinV);
        RenderUtils.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMinX, pMinZ, 1.0f, pMaxV);
        RenderUtils.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMinY, pMaxX, pMaxZ, 0.0f, pMaxV);
        RenderUtils.addVertex(pPose, pNormal, pConsumer, pRed, pGreen, pBlue, pAlpha, pMaxY, pMaxX, pMaxZ, 0.0f, pMinV);
    }

    public static void addVertex(Matrix4f pPose, Matrix3f pNormal, VertexConsumer pConsumer, float pRed, float pGreen, float pBlue, float pAlpha, float pY, float pX, float pZ, float pU, float pV) {
        pConsumer.m_252986_(pPose, pX, pY, pZ).m_85950_(pRed, pGreen, pBlue, pAlpha).m_7421_(pU, pV).m_86008_(OverlayTexture.f_118083_).m_85969_(0xF000F0).m_252939_(pNormal, 0.0f, 1.0f, 0.0f).m_5752_();
    }
}

