/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.nukateam.ntgl.Config;
import com.nukateam.ntgl.client.util.ClientDebug;
import com.nukateam.ntgl.client.util.handler.AimingHandler;
import com.nukateam.ntgl.client.util.pose.AimPose;
import com.nukateam.ntgl.client.util.pose.LimbPose;
import com.nukateam.ntgl.client.util.pose.WeaponPose;
import com.nukateam.ntgl.common.data.holders.GripType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;

public class TwoHandedPose
extends WeaponPose {
    @Override
    protected AimPose getUpPose() {
        AimPose upPose = new AimPose();
        upPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(60.0f, 0.0f, 10.0f)).setRightArm(new LimbPose().setRotationAngleX(-120.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-160.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-30.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        upPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(40.0f, 0.0f, 30.0f)).setItemTranslate(new Vector3f(-1.0f, 0.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-140.0f).setRotationAngleY(-55.0f).setRotationPointX(-5.0f).setRotationPointY(3.0f).setRotationPointZ(0.0f)).setLeftArm(new LimbPose().setRotationAngleX(-170.0f).setRotationAngleY(-20.0f).setRotationAngleZ(-35.0f).setRotationPointY(1.0f).setRotationPointZ(0.0f));
        return upPose;
    }

    @Override
    protected AimPose getForwardPose() {
        AimPose forwardPose = new AimPose();
        forwardPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(30.0f, -11.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-60.0f).setRotationAngleY(-55.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f).setRotationPointZ(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-65.0f).setRotationAngleY(-10.0f).setRotationAngleZ(5.0f).setRotationPointY(2.0f).setRotationPointZ(-1.0f));
        forwardPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(5.0f, -21.0f, 0.0f)).setRightArm(new LimbPose().setRotationAngleX(-85.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-90.0f).setRotationAngleY(-15.0f).setRotationAngleZ(0.0f).setRotationPointY(2.0f).setRotationPointZ(0.0f));
        return forwardPose;
    }

    @Override
    protected AimPose getDownPose() {
        AimPose downPose = new AimPose();
        downPose.getIdle().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-15.0f, -5.0f, 0.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 0.5f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(2.0f)).setLeftArm(new LimbPose().setRotationAngleX(-5.0f).setRotationAngleY(-20.0f).setRotationAngleZ(20.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        downPose.getAiming().setRenderYawOffset(45.0f).setItemRotation(new Vector3f(-20.0f, -5.0f, -10.0f)).setItemTranslate(new Vector3f(0.0f, -0.5f, 1.0f)).setRightArm(new LimbPose().setRotationAngleX(-30.0f).setRotationAngleY(-65.0f).setRotationAngleZ(0.0f).setRotationPointX(-5.0f).setRotationPointY(1.0f)).setLeftArm(new LimbPose().setRotationAngleX(-10.0f).setRotationAngleY(-20.0f).setRotationAngleZ(30.0f).setRotationPointY(5.0f).setRotationPointZ(0.0f));
        return downPose;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHumanoidModelRotation(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        if (hand == InteractionHand.OFF_HAND) {
            return;
        }
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            boolean right = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            ModelPart mainArm = right ? rightArm : leftArm;
            ModelPart secondaryArm = right ? leftArm : rightArm;
            mainArm.f_104203_ = (float)Math.toRadians(-55.0f + aimProgress * -30.0f);
            mainArm.f_104204_ = (float)Math.toRadians((-45.0f + aimProgress * -20.0f) * (right ? 1.0f : -1.0f));
            mainArm.f_104205_ = head.f_104205_;
            secondaryArm.f_104203_ = (float)Math.toRadians(-42.0f + aimProgress * -48.0f);
            secondaryArm.f_104204_ = (float)Math.toRadians((-15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f));
            secondaryArm.f_104205_ = head.f_104205_;
        } else {
            super.applyHumanoidModelRotation(entity, rightArm, leftArm, head, hand, aimProgress);
            float angle = this.getEntityPitch(entity);
            head.f_104203_ = (float)Math.toRadians((double)angle > 0.0 ? (double)(angle * 70.0f) : (double)(angle * 90.0f));
        }
    }

    @Override
    public void applyGeoModelRotation(LivingEntity entity, CoreGeoBone rightArm, CoreGeoBone leftArm, CoreGeoBone head, InteractionHand interactionHand) {
        float aimProgress = AimingHandler.get().getAimProgress(entity, Minecraft.m_91087_().m_91296_());
        boolean right = interactionHand == InteractionHand.MAIN_HAND;
        rightArm.setRotX((float)Math.toRadians(head.getRotX()));
        rightArm.setRotY((float)Math.toRadians(head.getRotY()));
        rightArm.setRotZ((float)Math.toRadians(head.getRotZ()));
        leftArm.setRotX((float)Math.toRadians(head.getRotX()));
        leftArm.setRotY((float)Math.toRadians(head.getRotY()));
        leftArm.setRotZ((float)Math.toRadians(head.getRotZ()));
        rightArm.setRotX((float)Math.toRadians(55.0f + aimProgress * 30.0f));
        rightArm.setRotY((float)Math.toRadians((45.0f + aimProgress * 20.0f) * (right ? 1.0f : -1.0f)));
        leftArm.setRotX((float)Math.toRadians(42.0f + aimProgress * 48.0f));
        leftArm.setRotY((float)Math.toRadians((15.0f + aimProgress * 5.0f) * (right ? 1.0f : -1.0f)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyEntityPreRender(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        if (((Boolean)Config.CLIENT.display.oldAnimations.get()).booleanValue()) {
            boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
            entity.f_20884_ = entity.f_19859_ + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
            entity.f_20883_ = entity.m_146908_() + (right ? 25.0f : -25.0f) + aimProgress * (right ? 20.0f : -20.0f);
        } else {
            super.applyEntityPreRender(entity, hand, aimProgress, poseStack, buffer);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        super.applyHeldItemTransforms(entity, hand, aimProgress, poseStack, buffer);
        poseStack.m_85837_(-0.5625, -0.8125, -1.5625);
        float aim = AimingHandler.get().getAimProgress(entity, Minecraft.m_91087_().m_91296_());
        poseStack.m_85837_((double)ClientDebug.X * 0.0625 * (double)aim, (double)ClientDebug.Y * 0.0625 * (double)aim, (double)ClientDebug.Z * 0.0625 * (double)aim);
        poseStack.m_85837_(-0.0625 * (double)aim, 0.1875 * (double)aim, 0.0);
    }

    @Override
    public boolean applyOffhandTransforms(LivingEntity entity, HumanoidModel<LivingEntity> model, ItemStack stack, PoseStack poseStack, float partialTicks) {
        return GripType.applyBackTransforms(entity, poseStack);
    }
}

