/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.client.util.pose;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.nukateam.ntgl.client.util.IHeldAnimation;
import com.nukateam.ntgl.client.util.pose.AimPose;
import com.nukateam.ntgl.client.util.pose.LimbPose;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib.core.animatable.model.CoreGeoBone;

public abstract class WeaponPose
implements IHeldAnimation {
    private AimPose upPose = this.getUpPose();
    private AimPose forwardPose = this.getForwardPose();
    private AimPose downPose = this.getDownPose();

    protected abstract AimPose getUpPose();

    protected abstract AimPose getForwardPose();

    protected abstract AimPose getDownPose();

    protected boolean hasAimPose() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHumanoidModelRotation(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart head, InteractionHand hand, float aimProgress) {
        Minecraft mc = Minecraft.m_91087_();
        boolean right = mc.f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        ModelPart mainArm = right ? rightArm : leftArm;
        ModelPart secondaryArm = right ? leftArm : rightArm;
        float angle = this.getEntityPitch(entity);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        this.applyAimPose(targetPose, mainArm, secondaryArm, angleAbs, zoom, right ? 1.0f : -1.0f, entity.m_6047_());
    }

    @Override
    public void applyGeoModelRotation(LivingEntity entity, CoreGeoBone rightArm, CoreGeoBone leftArm, CoreGeoBone head, InteractionHand interactionHand) {
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyEntityPreRender(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT ? hand == InteractionHand.MAIN_HAND : hand == InteractionHand.OFF_HAND;
        float angle = this.getEntityPitch(entity);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        float rightOffset = this.getValue(Float.valueOf(targetPose.getIdle().getRenderYawOffset()), Float.valueOf(targetPose.getAiming().getRenderYawOffset()), Float.valueOf(this.forwardPose.getIdle().getRenderYawOffset()), Float.valueOf(this.forwardPose.getAiming().getRenderYawOffset()), Float.valueOf(0.0f), angleAbs, zoom, right ? 1.0f : -1.0f);
        entity.f_20884_ = entity.f_19859_ + rightOffset;
        entity.f_20883_ = entity.m_146908_() + rightOffset;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void applyHeldItemTransforms(LivingEntity entity, InteractionHand hand, float aimProgress, PoseStack poseStack, MultiBufferSource buffer) {
        boolean right = Minecraft.m_91087_().f_91066_.m_232107_().m_231551_() == HumanoidArm.RIGHT;
        int leftHanded = right ? 1 : -1;
        poseStack.m_85837_(0.0, 0.0, 0.05);
        float angle = this.getEntityPitch(entity);
        float angleAbs = Math.abs(angle);
        float zoom = this.hasAimPose() ? aimProgress : 0.0f;
        AimPose targetPose = (double)angle > 0.0 ? this.downPose : this.upPose;
        AimPose.Instance idle = targetPose.getIdle();
        AimPose.Instance aiming = targetPose.getAiming();
        float translateX = this.getValue(Float.valueOf(idle.getItemTranslate().x()), Float.valueOf(aiming.getItemTranslate().x()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().x()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().x()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        float translateY = this.getValue(Float.valueOf(idle.getItemTranslate().y()), Float.valueOf(aiming.getItemTranslate().y()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().y()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().y()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        float translateZ = this.getValue(Float.valueOf(idle.getItemTranslate().z()), Float.valueOf(aiming.getItemTranslate().z()), Float.valueOf(this.forwardPose.getIdle().getItemTranslate().z()), Float.valueOf(this.forwardPose.getAiming().getItemTranslate().z()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        poseStack.m_85837_((double)translateX * 0.0625 * (double)leftHanded, (double)translateY * 0.0625, (double)translateZ * 0.0625);
        float rotateX = this.getValue(Float.valueOf(idle.getItemRotation().x()), Float.valueOf(aiming.getItemRotation().x()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().x()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().x()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        float rotateY = this.getValue(Float.valueOf(idle.getItemRotation().y()), Float.valueOf(aiming.getItemRotation().y()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().y()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().y()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        float rotateZ = this.getValue(Float.valueOf(idle.getItemRotation().z()), Float.valueOf(aiming.getItemRotation().z()), Float.valueOf(this.forwardPose.getIdle().getItemRotation().z()), Float.valueOf(this.forwardPose.getAiming().getItemRotation().z()), Float.valueOf(0.0f), angleAbs, zoom, 1.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(rotateX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(rotateY * (float)leftHanded));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(rotateZ * (float)leftHanded));
    }

    protected float getEntityPitch(LivingEntity entity) {
        if (Minecraft.m_91087_().m_91288_() == entity && Minecraft.m_91087_().f_91080_ != null) {
            return 0.0f;
        }
        return Mth.m_14179_((float)Minecraft.m_91087_().m_91296_(), (float)entity.f_19860_, (float)entity.m_146909_()) / 90.0f;
    }

    private void applyAimPose(AimPose targetPose, CoreGeoBone rightArm, CoreGeoBone leftArm, float partial, float zoom, float offhand, boolean sneaking) {
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getRightArm(), targetPose.getAiming().getRightArm(), this.forwardPose.getIdle().getRightArm(), this.forwardPose.getAiming().getRightArm(), rightArm, partial, zoom, offhand, sneaking);
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getLeftArm(), targetPose.getAiming().getLeftArm(), this.forwardPose.getIdle().getLeftArm(), this.forwardPose.getAiming().getLeftArm(), leftArm, partial, zoom, offhand, sneaking);
    }

    private void applyLimbPoseToModelRenderer(LimbPose targetIdlePose, LimbPose targetAimingPose, LimbPose idlePose, LimbPose aimingPose, CoreGeoBone modelPart, float partial, float zoom, float leftHanded, boolean sneaking) {
        modelPart.setRotX(this.getValue(targetIdlePose.getRotationAngleX(), targetAimingPose.getRotationAngleX(), idlePose.getRotationAngleX(), aimingPose.getRotationAngleX(), Float.valueOf(modelPart.getRotX()), partial, zoom, 1.0f));
        modelPart.setRotY(this.getValue(targetIdlePose.getRotationAngleY(), targetAimingPose.getRotationAngleY(), idlePose.getRotationAngleY(), aimingPose.getRotationAngleY(), Float.valueOf(modelPart.getRotY()), partial, zoom, leftHanded));
        modelPart.setRotZ(this.getValue(targetIdlePose.getRotationAngleZ(), targetAimingPose.getRotationAngleZ(), idlePose.getRotationAngleZ(), aimingPose.getRotationAngleZ(), Float.valueOf(modelPart.getRotZ()), partial, zoom, leftHanded));
    }

    private void applyAimPose(AimPose targetPose, ModelPart rightArm, ModelPart leftArm, float partial, float zoom, float offhand, boolean sneaking) {
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getRightArm(), targetPose.getAiming().getRightArm(), this.forwardPose.getIdle().getRightArm(), this.forwardPose.getAiming().getRightArm(), rightArm, partial, zoom, offhand, sneaking);
        this.applyLimbPoseToModelRenderer(targetPose.getIdle().getLeftArm(), targetPose.getAiming().getLeftArm(), this.forwardPose.getIdle().getLeftArm(), this.forwardPose.getAiming().getLeftArm(), leftArm, partial, zoom, offhand, sneaking);
    }

    private void applyLimbPoseToModelRenderer(LimbPose targetIdlePose, LimbPose targetAimingPose, LimbPose idlePose, LimbPose aimingPose, ModelPart modelPart, float partial, float zoom, float leftHanded, boolean sneaking) {
        modelPart.f_104203_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleX(), targetAimingPose.getRotationAngleX(), idlePose.getRotationAngleX(), aimingPose.getRotationAngleX(), Float.valueOf(modelPart.f_104203_), partial, zoom, 1.0f));
        modelPart.f_104204_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleY(), targetAimingPose.getRotationAngleY(), idlePose.getRotationAngleY(), aimingPose.getRotationAngleY(), Float.valueOf(modelPart.f_104204_), partial, zoom, leftHanded));
        modelPart.f_104205_ = (float)Math.toRadians(this.getValue(targetIdlePose.getRotationAngleZ(), targetAimingPose.getRotationAngleZ(), idlePose.getRotationAngleZ(), aimingPose.getRotationAngleZ(), Float.valueOf(modelPart.f_104205_), partial, zoom, leftHanded));
        modelPart.f_104200_ = this.getValue(targetIdlePose.getRotationPointX(), targetAimingPose.getRotationPointX(), idlePose.getRotationPointX(), aimingPose.getRotationPointX(), Float.valueOf(modelPart.f_104200_), partial, zoom, leftHanded);
        modelPart.f_104201_ = this.getValue(targetIdlePose.getRotationPointY(), targetAimingPose.getRotationPointY(), idlePose.getRotationPointY(), aimingPose.getRotationPointY(), Float.valueOf(modelPart.f_104201_), partial, zoom, 1.0f) + (sneaking ? 2.0f : 0.0f);
        modelPart.f_104202_ = this.getValue(targetIdlePose.getRotationPointZ(), targetAimingPose.getRotationPointZ(), idlePose.getRotationPointZ(), aimingPose.getRotationPointZ(), Float.valueOf(modelPart.f_104202_), partial, zoom, 1.0f);
    }

    private float getValue(@Nullable Float t1, @Nullable Float t2, Float s1, Float s2, Float def, float partial, float zoom, float leftHanded) {
        float start;
        float f = t1 != null && s1 != null ? (s1.floatValue() + (t1.floatValue() - s1.floatValue()) * partial) * leftHanded : (start = s1 != null ? s1.floatValue() * leftHanded : def.floatValue());
        float end = t2 != null && s2 != null ? (s2.floatValue() + (t2.floatValue() - s2.floatValue()) * partial) * leftHanded : (s2 != null ? s2.floatValue() * leftHanded : def.floatValue());
        return Mth.m_14179_((float)zoom, (float)start, (float)end);
    }
}

