/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.config.weapon;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nukateam.ntgl.common.data.config.weapon.AmmoConfig;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import com.nukateam.ntgl.common.util.annotation.Optional;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import org.apache.commons.lang3.tuple.Pair;

public class Fuel
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    @Optional
    private int max = 100;
    private boolean mandatory = true;
    private int amountPerUse = 0;
    private AmmoConfig ammo = new AmmoConfig();

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("Max", this.max);
        tag.m_128405_("amountPerUse", this.amountPerUse);
        tag.m_128379_("mandatory", this.mandatory);
        tag.m_128365_("ammo", (Tag)this.ammo.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("Max", 99)) {
            this.max = tag.m_128451_("Max");
        }
        if (tag.m_128425_("amountPerUse", 99)) {
            this.amountPerUse = tag.m_128451_("amountPerUse");
        }
        if (tag.m_128425_("Max", 99)) {
            this.mandatory = tag.m_128471_("mandatory");
        }
        if (tag.m_128425_("ammo", 10)) {
            this.ammo = AmmoConfig.create(tag.m_128469_("ammo"));
        }
    }

    public JsonObject toJsonObject() {
        Preconditions.checkArgument((this.max > 0 ? 1 : 0) != 0, (Object)"Max capacity must be more than zero");
        JsonObject object = new JsonObject();
        object.addProperty("max", (Number)this.max);
        object.addProperty("amountPerUse", (Number)this.amountPerUse);
        object.addProperty("mandatory", Boolean.valueOf(this.mandatory));
        object.add("ammo", (JsonElement)this.ammo.toJsonObject());
        return object;
    }

    public Fuel copy() {
        Fuel projectile = new Fuel();
        projectile.max = this.max;
        projectile.amountPerUse = this.amountPerUse;
        projectile.mandatory = this.mandatory;
        projectile.ammo = this.ammo;
        return projectile;
    }

    public AmmoConfig getAmmo() {
        return this.ammo;
    }

    public int getMax() {
        return this.max;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public int getAmountPerUse() {
        return this.amountPerUse;
    }

    public static Fuel create(CompoundTag tag) {
        Fuel ammo = new Fuel();
        ammo.deserializeNBT(tag);
        return ammo;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237113_((String)"Fuel");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {});
    }

    public static class Builder {
        private final Fuel ammo;

        private Builder() {
            this.ammo = new Fuel();
        }

        private Builder(Fuel ammo) {
            this.ammo = ammo.copy();
        }

        public static Builder create() {
            return new Builder();
        }

        public static Builder create(Fuel ammo) {
            return new Builder(ammo);
        }

        public Fuel build() {
            return this.ammo.copy();
        }

        public Builder setProjectileLife(ResourceLocation id, int life) {
            this.ammo.max = life;
            return this;
        }
    }
}

