/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.data.holders;

import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class AttachmentType {
    public static AttachmentType NONE = new AttachmentType("none");
    public static AttachmentType SCOPE = new AttachmentType("scope");
    public static AttachmentType BARREL = new AttachmentType("barrel");
    public static AttachmentType STOCK = new AttachmentType("stock");
    public static AttachmentType GRIP = new AttachmentType("grip");
    public static AttachmentType UNDER_BARREL = new AttachmentType("under_barrel");
    public static AttachmentType MAGAZINE = new AttachmentType("magazine");
    public static AttachmentType MUZZLE = new AttachmentType("muzzle");
    public static AttachmentType MELEE = new AttachmentType("melee");
    private static final Map<ResourceLocation, AttachmentType> typeMap = new HashMap<ResourceLocation, AttachmentType>();
    private final ResourceLocation id;

    public AttachmentType(ResourceLocation id) {
        this.id = id;
    }

    private AttachmentType(String name) {
        this.id = ResourceLocation.m_214293_((String)"ntgl", (String)name);
    }

    public static void registerType(AttachmentType mode) {
        typeMap.putIfAbsent(mode.getId(), mode);
    }

    public static AttachmentType getType(ResourceLocation id) {
        AttachmentType type = typeMap.get(id);
        if (type == null) {
            throw new JsonParseException("Attachment type \"" + id.toString() + "\" doesn't exists");
        }
        return type;
    }

    public static AttachmentType getType(String path) {
        ResourceLocation id = ResourceLocation.m_135820_((String)path);
        return AttachmentType.getType(id);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public ResourceLocation getIcon() {
        return ResourceLocation.m_214293_((String)this.getId().m_135827_(), (String)("textures/gui/icons/" + this.getId().m_135815_() + ".png"));
    }

    public String getTranslationKey() {
        return "slot." + this.getId().m_135827_() + ".attachment." + this.getId().m_135815_();
    }

    public MutableComponent getTranslationComponent() {
        return Component.m_237115_((String)this.getTranslationKey());
    }

    public boolean equals(ResourceLocation obj) {
        return this == AttachmentType.getType(obj);
    }

    public String toString() {
        return this.id.toString();
    }

    static {
        AttachmentType.registerType(NONE);
        AttachmentType.registerType(SCOPE);
        AttachmentType.registerType(BARREL);
        AttachmentType.registerType(STOCK);
        AttachmentType.registerType(GRIP);
        AttachmentType.registerType(UNDER_BARREL);
        AttachmentType.registerType(MAGAZINE);
        AttachmentType.registerType(MUZZLE);
        AttachmentType.registerType(MELEE);
    }
}

