/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.debug.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.nukateam.ntgl.client.util.helpers.ScreenUtil;
import com.nukateam.ntgl.common.debug.IDebugWidget;
import com.nukateam.ntgl.common.debug.IEditorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class EditorScreen
extends Screen {
    private static final ResourceLocation WINDOW_TEXTURE = ResourceLocation.m_214293_((String)"ntgl", (String)"textures/gui/debug.png");
    private static final int WIDTH = 150;
    private final Screen parent;
    private final IEditorMenu menu;
    private PropertyList list;
    private int windowWidth;
    private int windowHeight;
    private int windowLeft;
    private int windowTop;

    public EditorScreen(Screen parent, IEditorMenu menu) {
        super(menu.getEditorLabel());
        this.parent = parent;
        this.menu = menu;
    }

    protected void m_7856_() {
        ArrayList<Pair<Component, Supplier<IDebugWidget>>> widgets = new ArrayList<Pair<Component, Supplier<IDebugWidget>>>();
        this.menu.getEditorWidgets(widgets);
        this.windowWidth = 150;
        this.windowHeight = widgets.size() * 34 + 20 + 10;
        this.windowLeft = 10;
        this.windowTop = (this.f_96544_ - this.windowHeight) / 2;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237113_((String)"<"), btn -> Minecraft.m_91087_().m_91152_(this.parent)).m_252794_(this.windowLeft + 150 - 12 - 4, this.windowTop + 4).m_253046_(12, 12).m_253136_());
        this.list = new PropertyList();
        this.list.m_93488_(false);
        this.list.m_93496_(false);
        this.list.m_93507_(this.windowLeft + 10);
        this.m_7787_((GuiEventListener)this.list);
        widgets.forEach(pair -> {
            Object patt2688$temp = ((Supplier)pair.getRight()).get();
            if (patt2688$temp instanceof AbstractWidget) {
                AbstractWidget widget = (AbstractWidget)patt2688$temp;
                this.list.addEntry(new PropertyEntry((Component)pair.getLeft(), widget));
            }
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.drawHeader(this.windowLeft, this.windowTop, this.windowWidth);
        this.drawBody(this.windowLeft + 4, this.windowTop + 20, this.windowWidth - 8, this.windowHeight - 20);
        this.list.m_88315_(graphics, mouseX, mouseY, partialTicks);
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280430_(this.f_96547_, this.m_96636_(), this.windowLeft + 5, this.windowTop + 6, 0xFFFFFF);
    }

    public boolean m_7043_() {
        return false;
    }

    private void drawHeader(int x, int y, int width) {
        int height = 20;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WINDOW_TEXTURE);
        this.drawTexturedRect(x, y, 0, 0, 2, 2, 2, 2);
        this.drawTexturedRect(x + width - 2, y, 3, 0, 2, 2, 2, 2);
        this.drawTexturedRect(x, y + height - 2, 0, 18, 2, 2, 2, 2);
        this.drawTexturedRect(x + width - 2, y + height - 2, 3, 18, 2, 2, 2, 2);
        this.drawTexturedRect(x + 2, y, 2, 0, width - 4, 2, 1, 2);
        this.drawTexturedRect(x + 2, y + height - 2, 2, 18, width - 4, 2, 1, 2);
        this.drawTexturedRect(x, y + 2, 0, 2, 2, height - 4, 2, 16);
        this.drawTexturedRect(x + width - 2, y + 2, 3, 2, 2, height - 4, 2, 16);
        this.drawTexturedRect(x + 2, y + 2, 2, 2, width - 4, height - 4, 1, 16);
    }

    private void drawBody(int x, int y, int width, int height) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)WINDOW_TEXTURE);
        this.drawTexturedRect(x, y + height - 2, 5, 3, 2, 2, 2, 2);
        this.drawTexturedRect(x + width - 2, y + height - 2, 8, 3, 2, 2, 2, 2);
        this.drawTexturedRect(x + 2, y + height - 2, 7, 3, width - 4, 2, 1, 2);
        this.drawTexturedRect(x, y, 5, 2, 2, height - 2, 2, 1);
        this.drawTexturedRect(x + width - 2, y, 8, 2, 2, height - 2, 2, 1);
        this.drawTexturedRect(x + 2, y, 7, 2, width - 4, height - 2, 1, 1);
    }

    private void drawTexturedRect(int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
        buffer.m_5483_((double)x, (double)(y + height), 0.0).m_7421_((float)u * uScale, (float)(v + textureHeight) * vScale).m_5752_();
        buffer.m_5483_((double)(x + width), (double)(y + height), 0.0).m_7421_((float)(u + textureWidth) * uScale, (float)(v + textureHeight) * vScale).m_5752_();
        buffer.m_5483_((double)(x + width), (double)y, 0.0).m_7421_((float)(u + textureWidth) * uScale, (float)v * vScale).m_5752_();
        buffer.m_5483_((double)x, (double)y, 0.0).m_7421_((float)u * uScale, (float)v * vScale).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)buffer.m_231175_());
    }

    private class PropertyList
    extends ContainerObjectSelectionList<PropertyEntry> {
        public static final int ITEM_HEIGHT = 34;

        public PropertyList() {
            super(EditorScreen.this.f_96541_, EditorScreen.this.windowWidth - 20, EditorScreen.this.windowHeight, EditorScreen.this.windowTop + 20, EditorScreen.this.windowTop + EditorScreen.this.windowHeight - 5, 34);
        }

        public int addEntry(PropertyEntry entry) {
            return super.m_7085_((AbstractSelectionList.Entry)entry);
        }

        public void m_142291_(NarrationElementOutput output) {
        }

        protected int m_5756_() {
            return this.getLeft() + this.f_93388_ - 6;
        }

        public int m_5747_() {
            return super.m_5747_() - 2;
        }

        public int m_5759_() {
            return EditorScreen.this.windowWidth - 20 - 2 - (this.m_93518_() > 0 ? 6 : 0);
        }

        public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            ScreenUtil.startScissor(this.f_93393_, this.f_93390_, this.f_93392_ - this.f_93393_, this.f_93391_ - this.f_93390_);
            super.m_88315_(graphics, mouseX, mouseY, partialTick);
            ScreenUtil.endScissor();
        }
    }

    private class PropertyEntry
    extends ContainerObjectSelectionList.Entry<PropertyEntry> {
        private final Component label;
        private final AbstractWidget widget;

        public PropertyEntry(Component label, AbstractWidget widget) {
            this.label = label;
            this.widget = widget;
        }

        public void m_6311_(GuiGraphics graphics, int index, int top, int left, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
            graphics.m_280430_(EditorScreen.this.getMinecraft().f_91062_, this.label, left + 5, top, 0xFFFFFF);
            this.widget.m_252865_(left);
            this.widget.m_253211_(top + 10);
            this.widget.m_93674_(rowWidth);
            this.widget.m_88315_(graphics, mouseX, mouseY, partialTicks);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.widget);
        }

        public boolean m_5953_(double mouseX, double mouseY) {
            return ScreenUtil.isMouseWithin(EditorScreen.this.list.m_5747_(), EditorScreen.this.list.getTop(), EditorScreen.this.list.m_5759_(), EditorScreen.this.list.getHeight(), (int)mouseX, (int)mouseY) && super.m_5953_(mouseX, mouseY);
        }
    }
}

