/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchIngredient;
import com.nukateam.ntgl.common.foundation.crafting.WorkbenchRecipe;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

public class WorkbenchRecipeSerializer
implements RecipeSerializer<WorkbenchRecipe> {
    public WorkbenchRecipe fromJson(ResourceLocation recipeId, JsonObject parent) {
        ImmutableList.Builder builder = ImmutableList.builder();
        JsonArray input = GsonHelper.m_13933_((JsonObject)parent, (String)"materials");
        for (int i = 0; i < input.size(); ++i) {
            JsonObject object = input.get(i).getAsJsonObject();
            builder.add((Object)WorkbenchIngredient.fromJson(object));
        }
        if (!parent.has("result")) {
            throw new JsonSyntaxException("Missing result item entry");
        }
        JsonObject resultObject = GsonHelper.m_13930_((JsonObject)parent, (String)"result");
        ItemStack resultItem = ShapedRecipe.m_151274_((JsonObject)resultObject);
        return new WorkbenchRecipe(recipeId, resultItem, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    @Nullable
    public WorkbenchRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        ItemStack result = buffer.m_130267_();
        ImmutableList.Builder builder = ImmutableList.builder();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            builder.add((Object)((WorkbenchIngredient)Ingredient.m_43940_((FriendlyByteBuf)buffer)));
        }
        return new WorkbenchRecipe(recipeId, result, (ImmutableList<WorkbenchIngredient>)builder.build());
    }

    public void toNetwork(FriendlyByteBuf buffer, WorkbenchRecipe recipe) {
        buffer.m_130055_(recipe.getItem());
        buffer.m_130130_(recipe.getMaterials().size());
        for (WorkbenchIngredient ingredient : recipe.getMaterials()) {
            ingredient.m_43923_(buffer);
        }
    }
}

