/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.foundation.entity;

import com.nukateam.ntgl.common.data.WeaponData;
import com.nukateam.ntgl.common.foundation.entity.HitTarget;
import com.nukateam.ntgl.common.foundation.entity.ProjectileEntity;
import com.nukateam.ntgl.common.util.world.ExplosionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class ArrowLikeProjectile
extends ProjectileEntity {
    private boolean inGround;
    private BlockPos inBlockPos;
    private int shakeTime;

    public ArrowLikeProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public ArrowLikeProjectile(EntityType<? extends ProjectileEntity> entityType, Level worldIn, WeaponData data) {
        super(entityType, worldIn, data);
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("inGround", this.inGround);
        if (this.inBlockPos != null) {
            compound.m_128365_("inBlock", (Tag)NbtUtils.m_129224_((BlockPos)this.inBlockPos));
        }
        compound.m_128405_("shakeTime", this.shakeTime);
    }

    @Override
    protected void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.inGround = compound.m_128471_("inGround");
        if (compound.m_128441_("inBlock")) {
            CompoundTag blockPos = compound.m_128469_("inBlockPos");
            this.inBlockPos = NbtUtils.m_129239_((CompoundTag)blockPos);
        }
        this.shakeTime = compound.m_128451_("shakeTime");
    }

    @Override
    public void writeSpawnData(FriendlyByteBuf buffer) {
        super.writeSpawnData(buffer);
        buffer.writeBoolean(this.inGround);
        buffer.m_130064_(this.inBlockPos != null ? this.inBlockPos : BlockPos.f_121853_);
        buffer.m_130130_(this.shakeTime);
    }

    @Override
    public void readSpawnData(FriendlyByteBuf buffer) {
        super.readSpawnData(buffer);
        this.inGround = buffer.readBoolean();
        this.inBlockPos = buffer.m_130135_();
        this.shakeTime = buffer.m_130242_();
    }

    @Override
    protected void travel() {
        if (this.inGround) {
            this.m_20101_();
            if (this.shakeTime > 0) {
                --this.shakeTime;
            }
        } else {
            super.travel();
        }
    }

    @Override
    protected void onHitBlock(BlockHitResult hitResult, BlockState blockState) {
        if (!this.inGround) {
            this.inGround = true;
            this.inBlockPos = hitResult.m_82425_().m_7949_();
            this.shakeTime = 20;
            this.f_19812_ = false;
            this.m_20256_(Vec3.f_82478_);
            this.m_146884_(hitResult.m_82450_());
        }
        super.onHitBlock(hitResult, blockState);
    }

    @Override
    protected boolean removeOnHit(HitTarget hitTarget) {
        return hitTarget == HitTarget.ENTITY;
    }

    @Override
    protected void onExpired() {
        if (!this.inGround && ExplosionUtils.isExplosive(this.projectile.getExplosion())) {
            ExplosionUtils.createExplosion(this, this.projectile.getExplosion(), this.m_20182_());
        }
    }

    public void m_6123_(Player player) {
        if ((this.m_9236_().f_46443_ || this.inGround && this.shakeTime <= 0) && this.canBePickedUp(player)) {
            this.pickup(player);
        }
    }

    private boolean canBePickedUp(Player player) {
        return !this.m_213877_() && (player.m_150109_().m_36054_(this.getPickupItem()) || player.m_150110_().f_35937_);
    }

    protected ItemStack getPickupItem() {
        return this.ammo.m_41777_();
    }

    private void pickup(Player player) {
        if (player.m_150110_().f_35937_) {
            this.m_146870_();
        } else {
            player.m_7938_((Entity)this, 1);
            this.m_146870_();
        }
        this.m_5496_(SoundEvents.f_12019_, 0.2f, 1.0f);
    }
}

