/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.common.util.util;

import com.nukateam.ntgl.common.data.config.weapon.Fuel;
import com.nukateam.ntgl.common.data.config.weapon.Modules;
import com.nukateam.ntgl.common.data.config.weapon.ProjectileConfig;
import com.nukateam.ntgl.common.data.holders.AmmoHolder;
import com.nukateam.ntgl.common.data.holders.AttachmentType;
import com.nukateam.ntgl.common.data.holders.FireMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;

public class NbtUtils {
    public static CompoundTag writeVec3(Vec3 vec) {
        CompoundTag vecTag = new CompoundTag();
        vecTag.m_128347_("x", vec.f_82479_);
        vecTag.m_128347_("y", vec.f_82480_);
        vecTag.m_128347_("z", vec.f_82481_);
        return vecTag;
    }

    public static Vec3 readVec3(@Nullable CompoundTag tag) {
        if (tag != null) {
            return new Vec3(tag.m_128459_("x"), tag.m_128459_("y"), tag.m_128459_("z"));
        }
        return Vec3.f_82478_;
    }

    public static void writeVec3(FriendlyByteBuf buffer, Vec3 vec) {
        buffer.writeDouble(vec.f_82479_);
        buffer.writeDouble(vec.f_82480_);
        buffer.writeDouble(vec.f_82481_);
    }

    public static Vec3 readVec3(FriendlyByteBuf buffer) {
        return new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
    }

    public static CompoundTag serializeStringArray(ArrayList<String> array) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < array.size(); ++i) {
            tag.m_128359_(String.valueOf(i), array.get(i));
        }
        return tag;
    }

    public static ArrayList<String> deserializeStringArray(CompoundTag tag) {
        ArrayList<String> array = new ArrayList<String>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            array.add(tag.m_128461_(key));
        }
        return array;
    }

    public static <T> CompoundTag serializeSet(Set<T> array) {
        CompoundTag tag = new CompoundTag();
        Iterator<T> iterator = array.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            tag.m_128359_(String.valueOf(i), iterator.next().toString());
            ++i;
        }
        return tag;
    }

    public static <R> LinkedHashSet<R> deserializeSet(CompoundTag tag, Function<String, R> deserializer) {
        LinkedHashSet<R> set = new LinkedHashSet<R>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            set.add(deserializer.apply(tag.m_128461_(key)));
        }
        return set;
    }

    public static LinkedHashSet<FireMode> deserializeFireMode(CompoundTag tag) {
        return NbtUtils.deserializeSet(tag, FireMode::getType);
    }

    public static LinkedHashSet<ResourceLocation> deserializeResourceLocationSet(CompoundTag tag) {
        return NbtUtils.deserializeSet(tag, ResourceLocation::m_135820_);
    }

    public static <T extends INBTSerializable> CompoundTag serializeArray(ArrayList<T> array) {
        CompoundTag tag = new CompoundTag();
        for (int i = 0; i < array.size(); ++i) {
            tag.m_128365_(String.valueOf(i), ((INBTSerializable)array.get(i)).serializeNBT());
        }
        return tag;
    }

    public static HashMap<AmmoHolder, Fuel> deserializeFuelMap(CompoundTag tag) {
        HashMap<AmmoHolder, Fuel> map = new HashMap<AmmoHolder, Fuel>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            Fuel fuel = new Fuel();
            AmmoHolder resource = AmmoHolder.getType(key);
            fuel.deserializeNBT(tag.m_128469_(key));
            map.put(resource, fuel);
        }
        return map;
    }

    public static <K, R extends INBTSerializable> CompoundTag serializeMap(Map<K, R> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, R> entry : map.entrySet()) {
            tag.m_128365_(entry.getKey().toString(), ((INBTSerializable)entry.getValue()).serializeNBT());
        }
        return tag;
    }

    public static <K, V> HashMap<K, V> deserializeMap(CompoundTag tag, Function<String, K> keyDeserializer, BiFunction<CompoundTag, String, V> valueDeserializer) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (String nbtKey : tag.m_128431_()) {
            if (!tag.m_128441_(nbtKey)) continue;
            K key = keyDeserializer.apply(nbtKey);
            V value = valueDeserializer.apply(tag, nbtKey);
            map.put(key, value);
        }
        return map;
    }

    public static <V> LinkedHashMap<ResourceLocation, V> deserializeLinkedMap(CompoundTag tag, Function<CompoundTag, V> deserializer) {
        LinkedHashMap<ResourceLocation, V> map = new LinkedHashMap<ResourceLocation, V>();
        for (String nbtKey : tag.m_128431_()) {
            if (!tag.m_128425_(nbtKey, 10)) continue;
            ResourceLocation resource = ResourceLocation.m_135820_((String)nbtKey);
            V value = deserializer.apply(tag.m_128469_(nbtKey));
            map.put(resource, value);
        }
        return map;
    }

    public static HashMap<ResourceLocation, ProjectileConfig> deserializeProjectileMap(CompoundTag tag) {
        HashMap<ResourceLocation, ProjectileConfig> map = new HashMap<ResourceLocation, ProjectileConfig>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            ResourceLocation resource = ResourceLocation.m_135820_((String)key);
            ProjectileConfig projectile = ProjectileConfig.create(tag.m_128469_(key));
            map.put(resource, projectile);
        }
        return map;
    }

    public static ArrayList<Modules.Attachment> deserializeArray(CompoundTag tag) {
        ArrayList<Modules.Attachment> array = new ArrayList<Modules.Attachment>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            Modules.Attachment val = new Modules.Attachment();
            val.deserializeNBT(tag.m_128469_(key));
            array.add(val);
        }
        return array;
    }

    public static <K, R> CompoundTag serializeStringMap(Map<K, R> map) {
        CompoundTag tag = new CompoundTag();
        for (Map.Entry<K, R> entry : map.entrySet()) {
            tag.m_128359_(entry.getKey().toString(), entry.getValue().toString());
        }
        return tag;
    }

    public static HashMap<String, ResourceLocation> deserializeRLMap(CompoundTag tag) {
        HashMap<String, ResourceLocation> map = new HashMap<String, ResourceLocation>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 8)) continue;
            map.put(key, ResourceLocation.m_135820_((String)tag.m_128461_(key)));
        }
        return map;
    }

    public static <K, R extends INBTSerializable, T extends ArrayList<R>> CompoundTag serializeArrayMap(Map<K, T> map) {
        CompoundTag tag = new CompoundTag();
        for (K key : map.keySet()) {
            tag.m_128365_(key.toString(), (Tag)NbtUtils.serializeArray((ArrayList)map.get(key)));
        }
        return tag;
    }

    public static LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> deserializeAttachmentMap(CompoundTag tag) {
        LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>> array = new LinkedHashMap<AttachmentType, ArrayList<Modules.Attachment>>();
        for (String key : tag.m_128431_()) {
            if (!tag.m_128425_(key, 10)) continue;
            array.put(AttachmentType.getType(key), NbtUtils.deserializeArray(tag.m_128469_(key)));
        }
        return array;
    }
}

