/*
 * Decompiled with CFR 0.152.
 */
package com.nukateam.ntgl.mixin.chassis.common;

import com.nukateam.chassis_core.common.foundation.entity.WearableChassis;
import com.nukateam.chassis_core.common.util.helpers.PlayerUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerMixin
extends Entity {
    @Shadow
    private boolean f_36085_;

    public PlayerMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(method={"wantsToStopRiding()Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void wantsToStopRiding(CallbackInfoReturnable<Boolean> cir) {
        if (PlayerUtils.isWearingChassis(this)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"rideTick()V"}, at={@At(value="HEAD")}, cancellable=true)
    public void rideTick(CallbackInfo ci) {
        if (PlayerUtils.isWearingChassis(this)) {
            super.m_6083_();
            ci.cancel();
        }
    }

    @ModifyVariable(method={"hurt(Lnet/minecraft/world/damagesource/DamageSource;F)Z"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyDamageAmount(float amount, DamageSource source) {
        PlayerMixin player = this;
        if (PlayerUtils.isWearingChassis(player)) {
            WearableChassis chassis = PlayerUtils.getEntityChassis(player);
            assert (chassis != null);
            return chassis.getDamageAfterAbsorb(source, amount);
        }
        return amount;
    }
}

