/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.sounds;

import net.dadamalda.create_compatible_storage.CCSTags;
import net.dadamalda.create_compatible_storage.sounds.MountedStorageSound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MountedStorageSoundHandler {
    public static MountedStorageSound getSoundFromState(BlockState state) {
        if (state.is(CCSTags.BARREL_SOUND) || state.is(Blocks.BARREL)) {
            return MountedStorageSound.BARREL;
        }
        if (state.is(CCSTags.SHULKER_BOXES)) {
            return MountedStorageSound.SHULKER_BOX;
        }
        if (state.is(CCSTags.CHEST_SOUND)) {
            return MountedStorageSound.CHEST;
        }
        if (state.is(CCSTags.SILENT_MOUNTED_STORAGE)) {
            return MountedStorageSound.SILENT;
        }
        if (state.is(CCSTags.SD_CABINET_SOUND)) {
            return MountedStorageSound.SD_CABINET_VARIANT;
        }
        if (state.is(CCSTags.FR_DRAWERS)) {
            return MountedStorageSound.FR_DRAWER;
        }
        if (state.is(CCSTags.FR_KITCHEN_DRAWERS)) {
            return MountedStorageSound.FR_KITCHEN_DRAWER;
        }
        if (state.is(CCSTags.FR_STORAGE_CABINETS)) {
            return MountedStorageSound.FR_STORAGE_CABINET;
        }
        if (state.is(CCSTags.FR_KITCHEN_STORAGE_CABINETS)) {
            return MountedStorageSound.FR_STORAGE_CABINET;
        }
        if (state.is(CCSTags.FR_CRATES)) {
            return MountedStorageSound.FR_CRATE;
        }
        if (state.is(CCSTags.FR_COOLERS)) {
            return MountedStorageSound.FR_COOLER;
        }
        if (state.is(CCSTags.WW_CLOSETS)) {
            return MountedStorageSound.WW_CLOSET;
        }
        return MountedStorageSound.UNKNOWN;
    }

    public static void playOpeningSound(MountedStorageSound sound, ServerLevel level, Vec3 pos) {
        switch (sound) {
            case BARREL: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case SHULKER_BOX: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.SHULKER_BOX_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case CHEST: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case SD_CABINET_VARIANT: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.WOODEN_TRAPDOOR_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_DRAWER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.drawer.open"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_KITCHEN_DRAWER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.kitchen_drawer.open"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_STORAGE_CABINET: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cabinet.open"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_CRATE: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.BARREL_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.7f);
                break;
            }
            case FR_COOLER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cooler.open"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case WW_CLOSET: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.CHEST_OPEN, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    public static void playClosingSound(MountedStorageSound sound, ServerLevel level, Vec3 pos) {
        switch (sound) {
            case BARREL: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case SHULKER_BOX: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.SHULKER_BOX_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case CHEST: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case SD_CABINET_VARIANT: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.WOODEN_TRAPDOOR_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_DRAWER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.drawer.close"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_KITCHEN_DRAWER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.kitchen_drawer.close"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_STORAGE_CABINET: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cabinet.close"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case FR_CRATE: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.7f);
                break;
            }
            case FR_COOLER: {
                level.playSound(null, BlockPos.containing((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cooler.close"), SoundSource.BLOCKS, 1.0f, level.random.nextFloat() * 0.1f + 0.9f);
                break;
            }
            case WW_CLOSET: {
                level.playSound(null, BlockPos.containing((Position)pos), SoundEvents.CHEST_CLOSE, SoundSource.BLOCKS, 0.5f, level.random.nextFloat() * 0.1f + 0.9f);
            }
        }
    }

    private static SoundEvent getSound(String id) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)id));
    }
}

