/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.simple.SimpleMountedStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.item.ItemHelper;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class ClosetMountedStorage
extends SimpleMountedStorage {
    public static final MapCodec<ClosetMountedStorage> CODEC = SimpleMountedStorage.codec(ClosetMountedStorage::new);

    protected ClosetMountedStorage(MountedItemStorageType<?> type, IItemHandler handler) {
        super(type, handler);
    }

    public ClosetMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.CLOSET.get(), handler);
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof Container) {
            Container container = (Container)be;
            if (this.getSlots() == container.getContainerSize()) {
                ItemHelper.copyContents((IItemHandler)this, (IItemHandlerModifiable)new InvWrapper(container));
            }
        }
    }

    protected IItemHandlerModifiable getHandlerForMenu(StructureTemplate.StructureBlockInfo info, Contraption contraption) {
        BlockState state = info.state();
        ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
        if (type == ChestType.SINGLE) {
            return this;
        }
        Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
        Direction connectedDirection = type == ChestType.LEFT ? Direction.DOWN : Direction.UP;
        BlockPos otherHalfPos = info.pos().relative(connectedDirection);
        MountedItemStorage otherHalf = this.getOtherHalf(contraption, otherHalfPos, state.getBlock(), facing, type);
        if (otherHalf == null) {
            return this;
        }
        if (type == ChestType.LEFT) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{this, otherHalf});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{otherHalf, this});
    }

    @Nullable
    protected MountedItemStorage getOtherHalf(Contraption contraption, BlockPos localPos, Block block, Direction thisFacing, ChestType thisType) {
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos);
        if (info == null) {
            return null;
        }
        BlockState state = info.state();
        if (!state.is(block)) {
            return null;
        }
        Direction facing = (Direction)state.getValue((Property)ChestBlock.FACING);
        ChestType type = (ChestType)state.getValue((Property)ChestBlock.TYPE);
        return facing == thisFacing && type == thisType.getOpposite() ? (MountedItemStorage)contraption.getStorage().getMountedItems().storages.get((Object)localPos) : null;
    }
}

