/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.mojang.serialization.MapCodec;
import com.progwml6.ironchest.common.block.regular.entity.CrystalChestBlockEntity;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.codec.CreateCodecs;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.dadamalda.create_compatible_storage.foundation.ContraptionUtils;
import net.dadamalda.create_compatible_storage.menus.IronChestMenuProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class CrystalChestMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<CrystalChestMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(CrystalChestMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped).fieldOf("value");
    private boolean dirty;

    protected CrystalChestMountedStorage(MountedItemStorageType<?> type, IItemHandler wrapped) {
        super(type, (IItemHandlerModifiable)new Handler(wrapped));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public CrystalChestMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.CRYSTAL_CHEST.get(), handler);
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof CrystalChestBlockEntity) {
            CrystalChestBlockEntity crystalChest = (CrystalChestBlockEntity)be;
            NonNullList items = NonNullList.create();
            for (int i = 0; i < 108; ++i) {
                items.add((Object)((Handler)this.wrapped).getStackInSlot(i));
            }
            crystalChest.setItems(items);
        }
    }

    @Nullable
    protected MenuProvider createMenuProvider(Component name, IItemHandlerModifiable handler, Predicate<Player> stillValid, Consumer<Player> onClose) {
        return IronChestMenuProvider.create(name, handler, stillValid, onClose);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = ContraptionUtils.getBlockEntity(contraption, localPos);
        if (be instanceof CrystalChestBlockEntity) {
            CrystalChestBlockEntity crystalChest = (CrystalChestBlockEntity)be;
            NonNullList items = NonNullList.create();
            for (int i = 0; i < 108; ++i) {
                items.add((Object)((Handler)this.wrapped).getStackInSlot(i));
            }
            crystalChest.setItems(items);
            crystalChest.sortTopStacks();
            crystalChest.sendTopStacksPacket();
        }
    }

    @Nullable
    public static CrystalChestMountedStorage fromCrystalChest(BlockEntity be) {
        if (be instanceof CrystalChestBlockEntity) {
            CrystalChestMountedStorage crystalChestMountedStorage;
            Level level = be.getLevel();
            if (level == null) {
                return null;
            }
            BlockPos pos = be.getBlockPos();
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (handler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                crystalChestMountedStorage = new CrystalChestMountedStorage((IItemHandler)modifiable);
            } else {
                crystalChestMountedStorage = null;
            }
            return crystalChestMountedStorage;
        }
        return null;
    }

    public static final class Handler
    extends ItemStackHandler {
        private Runnable onChange = () -> {};

        private Handler(IItemHandler handler) {
            super(108);
            for (int i = 0; i < 108; ++i) {
                this.setStackInSlot(i, handler.getStackInSlot(i));
            }
        }

        protected void onContentsChanged(int slot) {
            this.onChange.run();
        }
    }
}

