/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.simple.SimpleMountedStorage;
import com.simibubi.create.content.contraptions.Contraption;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.dadamalda.create_compatible_storage.CCSTags;
import net.dadamalda.create_compatible_storage.foundation.PreciseContraptionInteractionStore;
import net.dadamalda.create_compatible_storage.foundation.VectorMathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class FurnitureRefurbishedMountedStorage
extends SimpleMountedStorage {
    public static final MapCodec<FurnitureRefurbishedMountedStorage> CODEC = SimpleMountedStorage.codec(FurnitureRefurbishedMountedStorage::new);

    protected FurnitureRefurbishedMountedStorage(MountedItemStorageType<?> type, IItemHandler handler) {
        super(type, handler);
    }

    public FurnitureRefurbishedMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.FURNITURE_REFURBISHED.get(), handler);
    }

    public boolean handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info) {
        AABB boundingBox;
        BlockState state = info.state();
        Direction facing = Direction.NORTH;
        if (info.state().hasProperty((Property)BlockStateProperties.FACING)) {
            facing = (Direction)info.state().getValue((Property)BlockStateProperties.FACING);
        } else if (info.state().hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        } else {
            return false;
        }
        Vec3 position = info.pos().getCenter();
        Vec3 clickPoint = PreciseContraptionInteractionStore.getLastInteraction(player);
        Vec3 localClickPoint = VectorMathUtils.unrotatePoint(clickPoint.subtract(position), facing);
        if (state.is(CCSTags.FR_STORAGE_CABINETS) && !(boundingBox = VectorMathUtils.makePixelAABB(-8, -8, 8, 8, 8, 8)).contains(localClickPoint)) {
            return false;
        }
        if (state.is(CCSTags.FR_KITCHEN_STORAGE_CABINETS) && !(boundingBox = VectorMathUtils.makePixelAABB(-8, -8, 6, 8, 8, 6)).contains(localClickPoint)) {
            return false;
        }
        if (state.is(CCSTags.FR_DRAWERS) && !(boundingBox = VectorMathUtils.makePixelAABB(-8, -8, 7, 8, 6, 7)).contains(localClickPoint)) {
            return false;
        }
        if (state.is(CCSTags.FR_KITCHEN_DRAWERS) && !(boundingBox = VectorMathUtils.makePixelAABB(-8, -8, 6, 8, 6, 6)).contains(localClickPoint)) {
            return false;
        }
        return super.handleInteraction(player, contraption, info);
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be == null) {
            return;
        }
        for (int i = 0; i < ((ItemStackHandler)this.wrapped).getSlots(); ++i) {
            ((BaseContainerBlockEntity)be).setItem(i, ((ItemStackHandler)this.wrapped).getStackInSlot(i));
            be.setChanged();
        }
    }
}

