/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.hollingsworth.arsnouveau.common.block.tile.RepositoryTile;
import com.mojang.serialization.MapCodec;
import com.simibubi.create.api.contraption.storage.SyncedMountedStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.WrapperMountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.codec.CreateCodecs;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.dadamalda.create_compatible_storage.foundation.ContraptionUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class RepositoryMountedStorage
extends WrapperMountedItemStorage<Handler>
implements SyncedMountedStorage {
    public static final MapCodec<RepositoryMountedStorage> CODEC = CreateCodecs.ITEM_STACK_HANDLER.xmap(RepositoryMountedStorage::new, storage -> (ItemStackHandler)storage.wrapped).fieldOf("value");
    private boolean dirty;

    protected RepositoryMountedStorage(MountedItemStorageType<?> type, IItemHandler wrapped) {
        super(type, (IItemHandlerModifiable)new Handler(wrapped));
        ((Handler)this.wrapped).onChange = () -> {
            this.dirty = true;
        };
    }

    public RepositoryMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.REPOSITORY.get(), handler);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void markClean() {
        this.dirty = false;
    }

    public void afterSync(Contraption contraption, BlockPos localPos) {
        BlockEntity be = ContraptionUtils.getBlockEntity(contraption, localPos);
        if (be instanceof RepositoryTile) {
            RepositoryTile repository = (RepositoryTile)be;
            for (int i = 0; i < 54; ++i) {
                repository.setItem(i, ((Handler)this.wrapped).getStackInSlot(i));
            }
        }
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof RepositoryTile) {
            RepositoryTile repository = (RepositoryTile)be;
            for (int i = 0; i < 54; ++i) {
                repository.setItem(i, ((Handler)this.wrapped).getStackInSlot(i));
            }
        }
    }

    @Nullable
    public static RepositoryMountedStorage fromRepository(BlockEntity be) {
        if (be instanceof RepositoryTile) {
            RepositoryMountedStorage repositoryMountedStorage;
            RepositoryTile repository = (RepositoryTile)be;
            Level level = be.getLevel();
            if (level == null) {
                return null;
            }
            BlockPos pos = be.getBlockPos();
            IItemHandler handler = (IItemHandler)level.getCapability(Capabilities.ItemHandler.BLOCK, pos, null);
            if (handler instanceof IItemHandlerModifiable) {
                IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
                repositoryMountedStorage = new RepositoryMountedStorage((IItemHandler)modifiable);
            } else {
                repositoryMountedStorage = null;
            }
            return repositoryMountedStorage;
        }
        return null;
    }

    public static final class Handler
    extends ItemStackHandler {
        private Runnable onChange = () -> {};

        private Handler(IItemHandler handler) {
            super(54);
            for (int i = 0; i < 54; ++i) {
                this.setStackInSlot(i, handler.getStackInSlot(i));
            }
        }

        protected void onContentsChanged(int slot) {
            this.onChange.run();
        }
    }
}

