/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.datagen;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.dadamalda.create_compatible_storage.CCSTags;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.data.BlockTagsProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class ModBlockTagsProvider
extends BlockTagsProvider {
    List<String> COLOURS = List.of("white", "light_gray", "gray", "black", "brown", "red", "orange", "yellow", "lime", "green", "cyan", "light_blue", "blue", "purple", "magenta", "pink");
    List<String> WOOD_TYPES = List.of("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "crimson", "warped", "mangrove", "bamboo", "cherry");
    List<String> QUARK_CHEST_TYPES = List.of("nether_brick", "purpur", "prismarine", "ancient", "azalea", "blossom");
    List<String> WOODWORKS_WOOD_TYPES = List.of("autumnity,maple", "atmospheric,rosewood", "atmospheric,morado", "atmospheric,yucca", "atmospheric,laurel", "atmospheric,aspen", "atmospheric,kousa", "atmospheric,grimwood", "environmental,willow", "environmental,pine", "environmental,plum", "environmental,wisteria", "upgrade_aquatic,driftwood", "upgrade_aquatic,river", "endergetic,poise", "windswept,holly", "windswept,chestnut", "windswept,pine");
    List<String> STONE_CHEST_STONE_TYPES = List.of("andesite", "calcite", "cobbled_deepslate", "cobblestone", "deepslate", "diorite", "granite", "prismarine", "stone", "tuff");

    public ModBlockTagsProvider(DataGenerator generator, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), registries, "create_compatible_storage", existingFileHelper);
    }

    protected void addTags(HolderLookup.Provider provider) {
        this.COLOURS.forEach(colour -> {
            this.addBlocksToTag(CCSTags.FR_KITCHEN_DRAWERS, "refurbished_furniture:" + colour + "_kitchen_drawer");
            this.addBlocksToTag(CCSTags.FR_STORAGE_CABINETS, "refurbished_furniture:" + colour + "_kitchen_storage_cabinet");
            this.addBlocksToTag(CCSTags.FR_COOLERS, "refurbished_furniture:" + colour + "_cooler");
        });
        this.WOOD_TYPES.forEach(wood_type -> {
            this.addChests(List.of("quark:" + wood_type + "_chest", "quark:" + wood_type + "_trapped_chest", "woodworks:" + wood_type + "_chest", "woodworks:trapped_" + wood_type + "_chest", "lolmcv:" + wood_type + "_chest", "lolmcv:" + wood_type + "_trapped_chest"));
            this.addBlocksToTag(CCSTags.UNCOOPERATIVE_STATIONARY_CHESTS, "woodworks:" + wood_type + "_chest", "woodworks:trapped_" + wood_type + "_chest");
            this.addBlocksToTag(CCSTags.FD_CABINETS, "farmersdelight:" + wood_type + "_cabinet");
            this.addBlocksToTag(CCSTags.SD_CABINET_VARIANTS, "storagedelight:" + wood_type + "_single_door_cabinet", "storagedelight:" + wood_type + "_cabinet_with_glass_doors");
            this.addBlocksToTag(CCSTags.SD_GLASS_CABINETS, "storagedelight:glass_" + wood_type + "_cabinet");
            this.addBlocksToTag(CCSTags.SD_BOOKSHELVES_WITH_DOOR, "storagedelight:" + wood_type + "_bookshelf_with_door");
            this.addBlocksToTag(CCSTags.SD_SMALL_DRAWERS, "storagedelight:small_" + wood_type + "_drawers");
            this.addBlocksToTag(CCSTags.SD_DRAWERS_WITH_BOOKS, "storagedelight:" + wood_type + "_drawer_with_books");
            this.addBlocksToTag(CCSTags.SD_DRAWERS_WITH_DOOR, "storagedelight:" + wood_type + "_drawer_with_door");
            this.addBlocksToTag(CCSTags.SD_DRAWERS, "storagedelight:" + wood_type + "_drawer");
            this.addBlocksToTag(CCSTags.FR_DRAWERS, "refurbished_furniture:" + wood_type + "_drawer");
            this.addBlocksToTag(CCSTags.FR_KITCHEN_DRAWERS, "refurbished_furniture:" + wood_type + "_kitchen_drawer");
            this.addBlocksToTag(CCSTags.FR_STORAGE_CABINETS, "refurbished_furniture:" + wood_type + "_storage_cabinet", "refurbished_furniture:" + wood_type + "_kitchen_storage_cabinet");
            this.addBlocksToTag(CCSTags.FR_CRATES, "refurbished_furniture:" + wood_type + "_crate");
            this.addBlocksToTag(CCSTags.FR_MAILBOXES, "refurbished_furniture:" + wood_type + "_mail_box");
        });
        this.WOODWORKS_WOOD_TYPES.forEach(wood_type -> {
            String namespace = wood_type.split(",")[0];
            String id = wood_type.split(",")[1];
            this.addChests(List.of(namespace + ":" + id + "_chest", namespace + ":trapped_" + id + "_chest"));
            this.addBlocksToTag(CCSTags.UNCOOPERATIVE_STATIONARY_CHESTS, namespace + ":" + id + "_chest", namespace + ":trapped_" + id + "_chest");
        });
        this.QUARK_CHEST_TYPES.forEach(chest_type -> this.addChests(List.of("quark:" + chest_type + "_chest", "quark:" + chest_type + "_trapped_chest")));
        this.STONE_CHEST_STONE_TYPES.forEach(stone_type -> {
            this.addChest("stonechest:chest_" + stone_type);
            this.addBlocksToTag(CCSTags.UNCOOPERATIVE_STATIONARY_CHESTS, "stonechest:chest_" + stone_type);
        });
        this.addBlocksToTag(CCSTags.FD_CABINETS, "mynethersdelight:red_nether_bricks_cabinet", "mynethersdelight:nether_bricks_cabinet", "mynethersdelight:blackstone_bricks_cabinet", "mynethersdelight:powdery_cabinet");
        this.addBlocksToTag(CCSTags.SILENT_MOUNTED_STORAGE, "farmersdelight:basket");
        this.addTagsToTag(CCSTags.SIMPLE_MOUNTED_STORAGE, CCSTags.FD_CABINETS);
        this.addBlocksToTag(CCSTags.SIMPLE_MOUNTED_STORAGE, "farmersdelight:basket");
        this.addTagsToTag(CCSTags.UNCOOPERATIVE_MOUNTED_STORAGE, CCSTags.SD_DRAWERS, CCSTags.SD_SMALL_DRAWERS, CCSTags.SD_DRAWERS_WITH_BOOKS, CCSTags.SD_CABINET_VARIANTS, CCSTags.SD_GLASS_CABINETS, CCSTags.SD_BOOKSHELVES_WITH_DOOR, CCSTags.SD_DRAWERS_WITH_DOOR, CCSTags.AF_DRAWERS, CCSTags.FR_STORAGE_CABINETS, CCSTags.FR_COOLERS, CCSTags.FR_DRAWERS, CCSTags.FR_KITCHEN_DRAWERS, CCSTags.FR_CRATES, CCSTags.FR_MAILBOXES);
        this.addTagsToTag(CCSTags.UNCOOPERATIVE_MOUNTED_STORAGE, "handcrafted:desks", "handcrafted:nightstands", "handcrafted:counters", "handcrafted:cupboards", "handcrafted:drawers", "handcrafted:shelves", "handcrafted:side_tables");
        this.addTagsToTag(CCSTags.UNCOOPERATIVE_STATIONARY_STORAGE, CCSTags.UNCOOPERATIVE_MOUNTED_STORAGE, CCSTags.UNCOOPERATIVE_STATIONARY_CHESTS);
        this.addTagsToTag(CCSTags.SINGLE_BLOCK_INVENTORIES, CCSTags.SILENT_MOUNTED_STORAGE, CCSTags.BARREL_SOUND, CCSTags.SD_CABINET_SOUND, CCSTags.FR_STORAGE_CABINETS, CCSTags.FR_COOLERS, CCSTags.FR_DRAWERS, CCSTags.FR_KITCHEN_DRAWERS, CCSTags.FR_CRATES);
        this.addTagsToTag(CCSTags.SILENT_MOUNTED_STORAGE, CCSTags.FR_MAILBOXES);
        this.addTagsToTag(CCSTags.SILENT_MOUNTED_STORAGE, "handcrafted:desks", "handcrafted:nightstands", "handcrafted:counters", "handcrafted:cupboards", "handcrafted:drawers", "handcrafted:shelves", "handcrafted:side_tables");
        this.addTagsToTag(CCSTags.BARREL_SOUND, CCSTags.FD_CABINETS, CCSTags.SD_DRAWERS, CCSTags.SD_SMALL_DRAWERS, CCSTags.SD_DRAWERS_WITH_BOOKS, CCSTags.AF_DRAWERS);
        this.addTagsToTag(CCSTags.SD_CABINET_SOUND, CCSTags.SD_CABINET_VARIANTS, CCSTags.SD_GLASS_CABINETS, CCSTags.SD_BOOKSHELVES_WITH_DOOR, CCSTags.SD_DRAWERS_WITH_DOOR);
    }

    private void addChest(String id) {
        this.tag(CCSTags.CHEST_MOUNTED_STORAGE).addOptional(ResourceLocation.parse((String)id));
    }

    private void addChests(List<String> ids) {
        ids.forEach(this::addChest);
    }

    @SafeVarargs
    private void addTagsToTag(TagKey<Block> tag, TagKey<Block> ... tags) {
        for (TagKey<Block> tag2 : tags) {
            this.tag(tag).addOptionalTag(tag2);
        }
    }

    private void addTagsToTag(TagKey<Block> tag, String ... tags) {
        for (String tag2 : tags) {
            this.tag(tag).addOptionalTag(ResourceLocation.parse((String)tag2));
        }
    }

    private void addBlocksToTag(TagKey<Block> tag, String ... blocks) {
        for (String block : blocks) {
            this.tag(tag).addOptional(ResourceLocation.parse((String)block));
        }
    }
}

