/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.mixin;

import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.utility.CreateLang;
import net.dadamalda.create_compatible_storage.CCSTags;
import net.dadamalda.create_compatible_storage.sounds.MountedStorageSound;
import net.dadamalda.create_compatible_storage.sounds.MountedStorageSoundHandler;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={MountedItemStorage.class})
public abstract class MountedItemStorageMixin {
    @Unique
    private MountedStorageSound create_compatible_storage$sound;

    @Inject(method={"getMenuName"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    protected void getMenuName(StructureTemplate.StructureBlockInfo info, Contraption contraption, CallbackInfoReturnable<Component> cir) {
        BlockState state = info.f_74676_();
        String translationKey = "";
        if (state.m_204336_(CCSTags.CHEST_MOUNTED_STORAGE)) {
            boolean isSingle = info.f_74676_().m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE;
            translationKey = isSingle ? "container.chest" : "container.chestDouble";
        } else if (state.m_204336_(CCSTags.SHULKER_BOXES)) {
            translationKey = "container.shulkerBox";
        } else if (state.m_204336_(CCSTags.FD_CABINETS)) {
            translationKey = "farmersdelight.container.cabinet";
        } else if (state.m_204336_(CCSTags.SD_CABINET_VARIANTS)) {
            translationKey = "container.storagedelight.cabinet_variant";
        } else if (state.m_204336_(CCSTags.SD_GLASS_CABINETS)) {
            translationKey = "container.storagedelight.glass_cabinet";
        } else if (state.m_204336_(CCSTags.SD_BOOKSHELVES_WITH_DOOR)) {
            translationKey = "container.storagedelight.bookshelf_door";
        } else if (state.m_204336_(CCSTags.SD_SMALL_DRAWERS)) {
            translationKey = "container.storagedelight.small_drawers";
        } else if (state.m_204336_(CCSTags.SD_DRAWERS_WITH_BOOKS)) {
            translationKey = "container.storagedelight.drawer_books";
        } else if (state.m_204336_(CCSTags.SD_DRAWERS_WITH_DOOR)) {
            translationKey = "container.storagedelight.drawer_door";
        } else if (state.m_204336_(CCSTags.SD_DRAWERS)) {
            translationKey = "container.storagedelight.drawer";
        } else if (state.m_204336_(CCSTags.FR_DRAWERS)) {
            translationKey = "container.refurbished_furniture.drawer";
        } else if (state.m_204336_(CCSTags.FR_KITCHEN_DRAWERS)) {
            translationKey = "container.refurbished_furniture.kitchen_drawer";
        } else if (state.m_204336_(CCSTags.FR_STORAGE_CABINETS)) {
            translationKey = "container.refurbished_furniture.storage_cabinet";
        } else if (state.m_204336_(CCSTags.FR_KITCHEN_STORAGE_CABINETS)) {
            translationKey = "container.refurbished_furniture.storage_cabinet";
        } else if (state.m_204336_(CCSTags.FR_COOLERS)) {
            translationKey = "container.refurbished_furniture.cooler";
        } else if (state.m_204336_(CCSTags.FR_CRATES)) {
            translationKey = "container.refurbished_furniture.crate";
        } else if (state.m_204336_(CCSTags.FR_MAILBOXES)) {
            translationKey = "container.refurbished_furniture.mailbox";
        } else if (state.m_204336_(CCSTags.AF_DRAWERS)) {
            translationKey = "container.another_furniture.drawer";
        } else if (state.m_204336_(CCSTags.WW_CLOSETS)) {
            boolean isSingle = info.f_74676_().m_61143_((Property)ChestBlock.f_51479_) == ChestType.SINGLE;
            String string = translationKey = isSingle ? "container.woodworks.closet" : "container.woodworks.closetDouble";
        }
        if (!translationKey.isEmpty()) {
            cir.setReturnValue((Object)CreateLang.translateDirect((String)"contraptions.moving_container", (Object[])new Object[]{Component.m_237115_((String)translationKey)}));
            cir.cancel();
        }
    }

    @Inject(method={"handleInteraction"}, at={@At(value="HEAD")}, remap=false)
    public void handleInteraction(ServerPlayer player, Contraption contraption, StructureTemplate.StructureBlockInfo info, CallbackInfoReturnable<Boolean> cir) {
        this.create_compatible_storage$sound = MountedStorageSoundHandler.getSoundFromState(info.f_74676_());
    }

    @Inject(method={"playClosingSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void playClosingSound(ServerLevel level, Vec3 pos, CallbackInfo ci) {
        if (this.create_compatible_storage$sound != MountedStorageSound.UNKNOWN) {
            MountedStorageSoundHandler.playClosingSound(this.create_compatible_storage$sound, level, pos);
            ci.cancel();
        }
    }

    @Inject(method={"playOpeningSound"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    public void playOpeningSound(ServerLevel level, Vec3 pos, CallbackInfo ci) {
        if (this.create_compatible_storage$sound != MountedStorageSound.UNKNOWN) {
            MountedStorageSoundHandler.playOpeningSound(this.create_compatible_storage$sound, level, pos);
            ci.cancel();
        }
    }
}

