/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.sounds;

import net.dadamalda.create_compatible_storage.CCSTags;
import net.dadamalda.create_compatible_storage.sounds.MountedStorageSound;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class MountedStorageSoundHandler {
    public static MountedStorageSound getSoundFromState(BlockState state) {
        if (state.m_204336_(CCSTags.BARREL_SOUND) || state.m_60713_(Blocks.f_50618_)) {
            return MountedStorageSound.BARREL;
        }
        if (state.m_204336_(CCSTags.SHULKER_BOXES)) {
            return MountedStorageSound.SHULKER_BOX;
        }
        if (state.m_204336_(CCSTags.SILENT_MOUNTED_STORAGE)) {
            return MountedStorageSound.SILENT;
        }
        if (state.m_204336_(CCSTags.SD_CABINET_SOUND)) {
            return MountedStorageSound.SD_CABINET_VARIANT;
        }
        if (state.m_204336_(CCSTags.FR_DRAWERS)) {
            return MountedStorageSound.FR_DRAWER;
        }
        if (state.m_204336_(CCSTags.FR_KITCHEN_DRAWERS)) {
            return MountedStorageSound.FR_KITCHEN_DRAWER;
        }
        if (state.m_204336_(CCSTags.FR_STORAGE_CABINETS)) {
            return MountedStorageSound.FR_STORAGE_CABINET;
        }
        if (state.m_204336_(CCSTags.FR_KITCHEN_STORAGE_CABINETS)) {
            return MountedStorageSound.FR_STORAGE_CABINET;
        }
        if (state.m_204336_(CCSTags.FR_CRATES)) {
            return MountedStorageSound.FR_CRATE;
        }
        if (state.m_204336_(CCSTags.FR_COOLERS)) {
            return MountedStorageSound.FR_COOLER;
        }
        if (state.m_204336_(CCSTags.WW_CLOSETS)) {
            return MountedStorageSound.WW_CLOSET;
        }
        return MountedStorageSound.UNKNOWN;
    }

    public static void playOpeningSound(MountedStorageSound sound, ServerLevel level, Vec3 pos) {
        switch (sound) {
            case BARREL: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11725_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case SHULKER_BOX: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_12409_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case SD_CABINET_VARIANT: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_12629_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_DRAWER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.drawer.open"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_KITCHEN_DRAWER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.kitchen_drawer.open"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_STORAGE_CABINET: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cabinet.open"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_CRATE: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11725_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.7f);
                break;
            }
            case FR_COOLER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cooler.open"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case WW_CLOSET: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    public static void playClosingSound(MountedStorageSound sound, ServerLevel level, Vec3 pos) {
        switch (sound) {
            case BARREL: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11724_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case SHULKER_BOX: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_12408_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case SD_CABINET_VARIANT: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_12628_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_DRAWER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.drawer.close"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_KITCHEN_DRAWER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.kitchen_drawer.close"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_STORAGE_CABINET: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cabinet.close"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case FR_CRATE: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11724_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.7f);
                break;
            }
            case FR_COOLER: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), MountedStorageSoundHandler.getSound("refurbished_furniture:block.cooler.close"), SoundSource.BLOCKS, 1.0f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                break;
            }
            case WW_CLOSET: {
                level.m_5594_(null, BlockPos.m_274446_((Position)pos), SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
        }
    }

    private static SoundEvent getSound(String id) {
        return (SoundEvent)BuiltInRegistries.f_256894_.m_7745_(ResourceLocation.parse((String)id));
    }
}

