/*
 * Decompiled with CFR 0.152.
 */
package net.dadamalda.create_compatible_storage.storage_types;

import com.mojang.serialization.Codec;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorage;
import com.simibubi.create.api.contraption.storage.item.MountedItemStorageType;
import com.simibubi.create.api.contraption.storage.item.simple.SimpleMountedStorage;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.foundation.item.ItemHelper;
import net.dadamalda.create_compatible_storage.CCSMountedStorageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.CombinedInvWrapper;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.Nullable;

public class ClosetMountedStorage
extends SimpleMountedStorage {
    public static final Codec<ClosetMountedStorage> CODEC = SimpleMountedStorage.codec(ClosetMountedStorage::new);

    protected ClosetMountedStorage(MountedItemStorageType<?> type, IItemHandler handler) {
        super(type, handler);
    }

    public ClosetMountedStorage(IItemHandler handler) {
        this((MountedItemStorageType)CCSMountedStorageTypes.CLOSET.get(), handler);
    }

    public void unmount(Level level, BlockState state, BlockPos pos, @Nullable BlockEntity be) {
        if (be instanceof Container) {
            Container container = (Container)be;
            if (this.getSlots() == container.m_6643_()) {
                ItemHelper.copyContents((IItemHandler)this, (IItemHandlerModifiable)new InvWrapper(container));
            }
        }
    }

    protected IItemHandlerModifiable getHandlerForMenu(StructureTemplate.StructureBlockInfo info, Contraption contraption) {
        BlockState state = info.f_74676_();
        ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        if (type == ChestType.SINGLE) {
            return this;
        }
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        Direction connectedDirection = type == ChestType.LEFT ? Direction.DOWN : Direction.UP;
        BlockPos otherHalfPos = info.f_74675_().m_121945_(connectedDirection);
        MountedItemStorage otherHalf = this.getOtherHalf(contraption, otherHalfPos, state.m_60734_(), facing, type);
        if (otherHalf == null) {
            return this;
        }
        if (type == ChestType.LEFT) {
            return new CombinedInvWrapper(new IItemHandlerModifiable[]{this, otherHalf});
        }
        return new CombinedInvWrapper(new IItemHandlerModifiable[]{otherHalf, this});
    }

    @Nullable
    protected MountedItemStorage getOtherHalf(Contraption contraption, BlockPos localPos, Block block, Direction thisFacing, ChestType thisType) {
        StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)contraption.getBlocks().get(localPos);
        if (info == null) {
            return null;
        }
        BlockState state = info.f_74676_();
        if (!state.m_60713_(block)) {
            return null;
        }
        Direction facing = (Direction)state.m_61143_((Property)ChestBlock.f_51478_);
        ChestType type = (ChestType)state.m_61143_((Property)ChestBlock.f_51479_);
        return facing == thisFacing && type == thisType.m_61486_() ? (MountedItemStorage)contraption.getStorage().getMountedItems().storages.get((Object)localPos) : null;
    }
}

