/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.common.block.entity;

import dev.jaronline.cuttingdelight.CuttingDelight;
import dev.jaronline.cuttingdelight.common.block.CustomCuttingBoardBlock;
import dev.jaronline.cuttingdelight.common.registry.BlockEntityTypeRegistry;
import dev.jaronline.cuttingdelight.mixin.CuttingBoardBlockEntityAccessor;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.advancement.CuttingBoardTrigger;
import vectorwing.farmersdelight.common.block.entity.CuttingBoardBlockEntity;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.utility.ItemUtils;

public class CustomCuttingBoardBlockEntity
extends CuttingBoardBlockEntity {
    public CustomCuttingBoardBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state);
    }

    public boolean processStoredStackUsingTool(CuttingBoardRecipe recipe, ItemStack toolStack, @Nullable Player player) {
        if (this.level == null) {
            return false;
        }
        if (this.isItemCarvingBoard()) {
            return false;
        }
        int itemCount = this.getStoredItem().getCount();
        if (toolStack.isDamageableItem() && (player == null || !player.hasInfiniteMaterials())) {
            itemCount = Math.min(itemCount, toolStack.getMaxDamage() - toolStack.getDamageValue());
        }
        if (itemCount < 1) {
            CuttingDelight.LOGGER.warn("Cutting Board at {} tried to process with a broken tool!", (Object)this.worldPosition);
            return false;
        }
        ArrayList results = new ArrayList();
        int fortuneLevel = EnchantmentHelper.getTagEnchantmentLevel((Holder)((Holder)this.level.holder(Enchantments.FORTUNE).get()), (ItemStack)toolStack);
        for (int i = 0; i < itemCount; ++i) {
            results.addAll(recipe.rollResults(this.level.random, fortuneLevel));
        }
        for (ItemStack resultStack : results) {
            Direction direction = ((Direction)this.getBlockState().getValue((Property)CustomCuttingBoardBlock.FACING)).getCounterClockWise();
            ItemUtils.spawnItemEntity((Level)this.level, (ItemStack)resultStack.copy(), (double)((double)this.worldPosition.getX() + 0.5 + (double)direction.getStepX() * 0.2), (double)((double)this.worldPosition.getY() + 0.2), (double)((double)this.worldPosition.getZ() + 0.5 + (double)direction.getStepZ() * 0.2), (double)((float)direction.getStepX() * 0.2f), (double)0.0, (double)((float)direction.getStepZ() * 0.2f));
        }
        if (!this.level.isClientSide) {
            toolStack.hurtAndBreak(itemCount, (ServerLevel)this.level, (LivingEntity)player, item -> {});
        }
        this.playProcessingSound(recipe.getSoundEvent().orElse(null), toolStack, this.getStoredItem());
        this.removeItem(itemCount);
        if (player instanceof ServerPlayer) {
            ((CuttingBoardTrigger)ModAdvancements.USE_CUTTING_BOARD.get()).trigger((ServerPlayer)player);
        }
        return true;
    }

    @NotNull
    public BlockEntityType<?> getType() {
        return (BlockEntityType)BlockEntityTypeRegistry.getInstance().cuttingBoard.get();
    }

    public boolean addStack(ItemStack itemStack) {
        if (this.isEmpty() && !itemStack.isEmpty()) {
            CuttingBoardBlockEntityAccessor accessor = (CuttingBoardBlockEntityAccessor)((Object)this);
            accessor.getInventory().setStackInSlot(0, itemStack.split(itemStack.getCount()));
            accessor.setItemCarvingBoard(false);
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeItem(int count) {
        if (!this.isEmpty()) {
            CuttingBoardBlockEntityAccessor accessor = (CuttingBoardBlockEntityAccessor)((Object)this);
            accessor.setItemCarvingBoard(false);
            ItemStack item = this.getStoredItem().split(count);
            this.inventoryChanged();
            return item;
        }
        return ItemStack.EMPTY;
    }

    public ItemStack removeStack() {
        return this.removeItem(this.getStoredItem().getCount());
    }

    public void empty() {
        CuttingBoardBlockEntityAccessor accessor = (CuttingBoardBlockEntityAccessor)((Object)this);
        accessor.getInventory().setStackInSlot(0, ItemStack.EMPTY);
    }
}

