/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.data;

import dev.jaronline.cuttingdelight.data.BlockLoot;
import dev.jaronline.cuttingdelight.data.BlockStates;
import dev.jaronline.cuttingdelight.data.BlockTags;
import dev.jaronline.cuttingdelight.data.ItemModels;
import dev.jaronline.cuttingdelight.data.Recipes;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;

@EventBusSubscriber(modid="cuttingdelight")
public class DataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        generator.addProvider(event.includeServer(), (DataProvider)new BlockTags(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new Recipes(output, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(output, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(BlockLoot::new, LootContextParamSets.BLOCK)), lookupProvider));
        BlockStates blockStates = new BlockStates(output, existingFileHelper);
        generator.addProvider(event.includeClient(), (DataProvider)blockStates);
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModels(output, blockStates.models().existingFileHelper));
    }
}

