/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.server;

import dev.jaronline.cuttingdelight.common.block.entity.CustomCuttingBoardBlockEntity;
import dev.jaronline.cuttingdelight.common.network.CutPayload;
import dev.jaronline.cuttingdelight.common.network.CuttingBoardEmptiedPayload;
import dev.jaronline.cuttingdelight.common.network.CuttingBoardFilledPayload;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class ServerPayloadHandler {
    public static void handleCut(CutPayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        Recipe<?> recipe = payload.recipe();
        if (!(recipe instanceof CuttingBoardRecipe)) {
            throw new IllegalArgumentException("Expected CuttingBoardRecipe but found: " + payload.recipe().getClass().getSimpleName());
        }
        CuttingBoardRecipe cuttingRecipe = (CuttingBoardRecipe)recipe;
        cuttingBoardEntity.processStoredStackUsingTool(cuttingRecipe, context.player().getMainHandItem(), context.player());
    }

    public static void handleCuttingBoardEmptied(CuttingBoardEmptiedPayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        cuttingBoardEntity.empty();
    }

    public static void handleCuttingBoardFilled(CuttingBoardFilledPayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        cuttingBoardEntity.addStack(payload.itemStack());
    }
}

