/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.common.block;

import dev.jaronline.cuttingdelight.client.gui.menu.CuttingBoardMenu;
import dev.jaronline.cuttingdelight.common.block.entity.CustomCuttingBoardBlockEntity;
import dev.jaronline.cuttingdelight.common.registry.BlockEntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.tag.ModTags;

public class CustomCuttingBoardBlock
extends CuttingBoardBlock {
    private final BlockEntityTypeRegistry blockEntityTypes = BlockEntityTypeRegistry.getInstance();

    public CustomCuttingBoardBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new CuttingBoardMenu(containerId, playerInventory, blockEntity), (Component)this.getName());
    }

    @NotNull
    public ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        BlockEntity tileEntity = level.getBlockEntity(pos);
        if (tileEntity instanceof CustomCuttingBoardBlockEntity) {
            CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)tileEntity;
            ItemStack heldStack = player.getItemInHand(hand);
            ItemStack offhandStack = player.getOffhandItem();
            if (cuttingBoardEntity.isEmpty()) {
                if (!offhandStack.isEmpty()) {
                    if (hand.equals((Object)InteractionHand.MAIN_HAND) && !offhandStack.is(ModTags.OFFHAND_EQUIPMENT) && !(heldStack.getItem() instanceof BlockItem)) {
                        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                    }
                    if (hand.equals((Object)InteractionHand.OFF_HAND) && offhandStack.is(ModTags.OFFHAND_EQUIPMENT)) {
                        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                    }
                }
                if (heldStack.isEmpty()) {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
                if (cuttingBoardEntity.addStack(player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
                    return ItemInteractionResult.SUCCESS;
                }
            } else {
                if (!heldStack.isEmpty()) {
                    if (!level.isClientSide && player instanceof ServerPlayer) {
                        ServerPlayer serverPlayer = (ServerPlayer)player;
                        serverPlayer.openMenu(state.getMenuProvider(level, pos), pos);
                    }
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (hand.equals((Object)InteractionHand.MAIN_HAND)) {
                    if (!player.isCreative()) {
                        ItemStack removed;
                        ItemStack itemStack = removed = player.isCrouching() ? cuttingBoardEntity.removeItem() : cuttingBoardEntity.removeStack();
                        if (!player.getInventory().add(removed)) {
                            Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)removed);
                        }
                    } else if (player.isCrouching()) {
                        cuttingBoardEntity.removeItem();
                    } else {
                        cuttingBoardEntity.removeStack();
                    }
                    level.playSound(null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOOD_HIT, SoundSource.BLOCKS, 0.25f, 0.5f);
                    return ItemInteractionResult.SUCCESS;
                }
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hit);
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return ((BlockEntityType)this.blockEntityTypes.cuttingBoard.get()).create(pos, state);
    }

    @EventBusSubscriber(modid="cuttingdelight")
    public static class ToolCarvingEvent {
        @SubscribeEvent
        public static void onSneakPlaceTool(PlayerInteractEvent.RightClickBlock event) {
            Level level = event.getLevel();
            BlockPos pos = event.getPos();
            Player player = event.getEntity();
            ItemStack heldStack = player.getMainHandItem();
            BlockEntity tileEntity = level.getBlockEntity(event.getPos());
            if (!player.isSecondaryUseActive() || heldStack.isEmpty() || !(tileEntity instanceof CustomCuttingBoardBlockEntity)) {
                return;
            }
            CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)tileEntity;
            if (cuttingBoardEntity.isEmpty()) {
                if (cuttingBoardEntity.addItem(player.getAbilities().instabuild ? heldStack.copy() : heldStack)) {
                    level.playSound((Player)null, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 0.8f);
                    event.setCanceled(true);
                    event.setCancellationResult(InteractionResult.SUCCESS);
                }
                return;
            }
            ItemStack boardStack = cuttingBoardEntity.getStoredItem().copy();
            if (cuttingBoardEntity.processStoredItemUsingTool(heldStack, player)) {
                CuttingBoardBlock.spawnCuttingParticles((Level)level, (BlockPos)pos, (ItemStack)boardStack, (int)5);
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }
}

