/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.data;

import dev.jaronline.cuttingdelight.common.registry.BlockRegistry;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;

public class BlockStates
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;
    private final BlockRegistry blocks = BlockRegistry.getInstance();

    public BlockStates(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "cuttingdelight", exFileHelper);
    }

    private String blockName(Block block) {
        return BuiltInRegistries.BLOCK.getKey((Object)block).getPath();
    }

    public ResourceLocation resourceBlock(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)"cuttingdelight", (String)("block/" + path));
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.customHorizontalBlock((Block)this.blocks.cuttingBoard.get(), $ -> this.existingModel((Block)this.blocks.cuttingBoard.get()), new Property[]{CuttingBoardBlock.WATERLOGGED});
    }

    public void customHorizontalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(((int)((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot() + 180) % 360).build(), ignored);
    }
}

