/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.compat.jade;

import net.dries007.tfc.util.Helpers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.blockentities.LogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blocks.LogPileExBlock;

@WailaPlugin
public final class JadeIntegration
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registry) {
        registry.registerBlockDataProvider((IServerDataProvider)LogPileComponentProvider.INSTANCE, LogPileExBlockEntity.class);
    }

    public void registerClient(IWailaClientRegistration registry) {
        registry.registerBlockComponent((IComponentProvider)LogPileComponentProvider.INSTANCE, LogPileExBlock.class);
    }

    private static enum LogPileComponentProvider implements IBlockComponentProvider,
    IServerDataProvider<BlockAccessor>
    {
        INSTANCE;

        private static final String KEY_ITEM = "Item";
        private static final String KEY_ITEMSTACK_COUNT = "Count";
        private static final String KEY_ITEMSTACK_NAME = "Name";
        private static final String KEY_ITEMSTACK_LIST = "Itemstacks";
        private static final ResourceLocation LOG_PILE_TOOLTIP_UID;

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig pluginConfig) {
            if (accessor.getBlockEntity() instanceof LogPileExBlockEntity) {
                ListTag listTag = accessor.getServerData().getList(KEY_ITEMSTACK_LIST, 10);
                for (int i = 0; i < listTag.size(); ++i) {
                    CompoundTag stackTag = listTag.getCompound(i);
                    Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)stackTag.getString(KEY_ITEM)));
                    IElement icon = IElementHelper.get().item(new ItemStack((ItemLike)item), 0.5f);
                    tooltip.add(icon);
                    tooltip.append((Component)Component.empty().append(stackTag.getInt(KEY_ITEMSTACK_COUNT) + "x ").append(stackTag.getString(KEY_ITEMSTACK_NAME)));
                }
            }
        }

        public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            if (blockEntity instanceof LogPileExBlockEntity) {
                LogPileExBlockEntity pile = (LogPileExBlockEntity)blockEntity;
                ListTag listTag = new ListTag();
                for (ItemStack stack : Helpers.iterate((IItemHandler)pile.getInventory())) {
                    if (stack.isEmpty()) continue;
                    CompoundTag stackTag = new CompoundTag();
                    stackTag.putString(KEY_ITEM, stack.getItem().toString());
                    stackTag.putString(KEY_ITEMSTACK_NAME, stack.getHoverName().getString());
                    stackTag.putInt(KEY_ITEMSTACK_COUNT, stack.getCount());
                    listTag.add((Object)stackTag);
                }
                tag.put(KEY_ITEMSTACK_LIST, (Tag)listTag);
            }
        }

        public ResourceLocation getUid() {
            return LOG_PILE_TOOLTIP_UID;
        }

        static {
            LOG_PILE_TOOLTIP_UID = TFCWoodworking.getResource("log_pile_ex");
        }
    }
}

