/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.recipes.inworld;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import java.util.Optional;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import su.uTa4u.tfcwoodwork.ModConfig;
import su.uTa4u.tfcwoodwork.TFCWoodworking;
import su.uTa4u.tfcwoodwork.blocks.AbstractDebarkedWood;
import su.uTa4u.tfcwoodwork.blocks.BlockType;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;
import su.uTa4u.tfcwoodwork.entities.AbstractWoodProjectile;
import su.uTa4u.tfcwoodwork.entities.LogHalfProjectile;
import su.uTa4u.tfcwoodwork.entities.LogQuarterProjectile;

public enum Action implements StringRepresentable
{
    DROP_CARDINAL("drop_cardinal", 4){

        @Override
        public void accept(Level level, BlockPos pos, ItemStack itemStack, Direction playerDir) {
            Action.spawnDropsPrecise(level, pos, 0.5, 0.5, -0.2, itemStack, 0.0, 0.05, -0.05);
            Action.spawnDropsPrecise(level, pos, 0.5, 0.5, 1.2, itemStack, 0.0, 0.05, 0.05);
            Action.spawnDropsPrecise(level, pos, -0.2, 0.5, 0.5, itemStack, -0.05, 0.05, 0.0);
            Action.spawnDropsPrecise(level, pos, 1.2, 0.5, 0.5, itemStack, 0.05, 0.05, 0.0);
        }
    }
    ,
    DROP_CENTER("drop_center", 1){

        @Override
        public void accept(Level level, BlockPos pos, ItemStack itemStack, Direction playerDir) {
            Action.spawnDropsPrecise(level, pos, 0.5, 0.5, 0.5, itemStack, 0.0, 0.0, 0.0);
        }
    }
    ,
    DROP_ABOVE("drop_above", 1){

        @Override
        public void accept(Level level, BlockPos pos, ItemStack itemStack, Direction playerDir) {
            Action.spawnDropsPrecise(level, pos, 0.5, 1.05, 0.5, itemStack, 0.0, 0.0, 0.0);
        }
    }
    ,
    SHOOT_AS_BLOCK("shoot_as_block", 2){

        @Override
        public void accept(Level level, BlockPos pos, ItemStack itemStack, Direction playerDir) {
            AbstractWoodProjectile projRight;
            Object projLeft;
            BlockState chopped = level.getBlockState(pos);
            Wood wood = Action.getWoodFromState(chopped);
            if (wood == null) {
                return;
            }
            double deltaX = 0.0;
            double deltaY = 0.25;
            double deltaZ = 0.0;
            double offsetX = 0.0;
            double offsetY = 0.5;
            double offsetZ = 0.0;
            Optional dirOpt = chopped.getOptionalValue((Property)AbstractDebarkedWood.FACING);
            Direction dir = dirOpt.orElse(playerDir);
            switch (dir) {
                case NORTH: 
                case UP: 
                case DOWN: {
                    deltaX = 0.75;
                    offsetX = 0.1875;
                    break;
                }
                case SOUTH: {
                    deltaX = -0.75;
                    offsetX = -0.1875;
                    break;
                }
                case WEST: {
                    deltaZ = 0.75;
                    offsetZ = 0.1875;
                    break;
                }
                case EAST: {
                    deltaZ = -0.75;
                    offsetZ = -0.1875;
                }
            }
            if (((Boolean)ModConfig.LOG_PROJECTILE_VS_ITEM.get()).booleanValue()) {
                Item item = itemStack.getItem();
                Block block = Block.byItem((Item)item);
                if (block == Blocks.AIR) {
                    TFCWoodworking.LOGGER.error("Attempted to shoot non existent projectile, why?");
                    return;
                }
                BlockState state = block.defaultBlockState();
                if (item == ModBlocks.WOODS.get(wood).get((Object)BlockType.DEBARKED_HALF).asItem()) {
                    projLeft = new LogHalfProjectile(pos, state, 0.5 + offsetX, offsetY, 0.5 + offsetZ, level, dir, true);
                    projRight = new LogHalfProjectile(pos, state, 0.5 - offsetX, offsetY, 0.5 - offsetZ, level, dir, false);
                } else if (item == ModBlocks.WOODS.get(wood).get((Object)BlockType.DEBARKED_QUARTER).asItem()) {
                    projLeft = new LogQuarterProjectile(pos, state, 0.5 + offsetX, offsetY, 0.5 + offsetZ, level, dir, true);
                    projRight = new LogQuarterProjectile(pos, state, 0.5 - offsetX, offsetY, 0.5 - offsetZ, level, dir, false);
                } else {
                    TFCWoodworking.LOGGER.error("Attempted to shoot non-existent projectile, why?");
                    return;
                }
                ((AbstractWoodProjectile)((Object)projLeft)).shoot(deltaX, deltaY, deltaZ, 0.3f, 0.0f);
                ((AbstractWoodProjectile)projRight).shoot(-deltaX, deltaY, -deltaZ, 0.3f, 0.0f);
            } else {
                projLeft = new ItemEntity(level, (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, itemStack, deltaX / 4.0, deltaY, deltaZ / 4.0);
                projRight = new ItemEntity(level, (double)pos.getX() + 0.5 - offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 - offsetZ, itemStack, -deltaX / 4.0, deltaY, -deltaZ / 4.0);
            }
            level.addFreshEntity((Entity)projLeft);
            level.addFreshEntity((Entity)projRight);
        }
    };

    public static final Action[] VALUES;
    public static final StreamCodec<ByteBuf, Action> STREAM_CODEC;
    private final String name;
    private final Component prettyName;
    private final int countFactor;

    private Action(String name, int countFactor) {
        this.name = name;
        this.prettyName = Component.translatable((String)("tfcwoodwork.itemstack_action." + this.name));
        this.countFactor = countFactor;
    }

    public abstract void accept(Level var1, BlockPos var2, ItemStack var3, Direction var4);

    @NotNull
    public String getSerializedName() {
        return this.name;
    }

    public Component getPrettyName() {
        return this.prettyName;
    }

    public int getCountFactor() {
        return this.countFactor;
    }

    private static void spawnDropsPrecise(Level level, BlockPos pos, double offsetX, double offsetY, double offsetZ, ItemStack itemStack, double deltaX, double deltaY, double deltaZ) {
        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, itemStack, deltaX, deltaY, deltaZ));
    }

    @Nullable
    private static Wood getWoodFromState(BlockState state) {
        for (Map.Entry entry : TFCBlocks.WOODS.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (!state.is((Block)((TFCBlocks.Id)entry2.getValue()).get())) continue;
                return (Wood)entry.getKey();
            }
        }
        for (Map.Entry<Object, Object> entry : ModBlocks.WOODS.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                if (!state.is((Block)((TFCBlocks.Id)entry2.getValue()).get())) continue;
                return (Wood)entry.getKey();
            }
        }
        return null;
    }

    static {
        VALUES = Action.values();
        STREAM_CODEC = ByteBufCodecs.idMapper(id -> VALUES[id], Enum::ordinal);
    }
}

