/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.blocks;

import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.EntityBlockExtension;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.IForgeBlockExtension;
import net.dries007.tfc.common.blocks.TFCBlockStateProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.util.Helpers;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.blockentities.LogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blockentities.ModBlockEntities;
import su.uTa4u.tfcwoodwork.blocks.BurningLogPileExBlock;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;

public class LogPileExBlock
extends DeviceBlock
implements IForgeBlockExtension,
EntityBlockExtension {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final IntegerProperty COUNT = TFCBlockStateProperties.COUNT_1_16;
    private static final VoxelShape[][] SHAPES_BY_DIR_BY_COUNT = (VoxelShape[][])Util.make((Object)new VoxelShape[2][16], shapes -> {
        VoxelShape box2;
        VoxelShape box1;
        int count;
        double[][] box2ByCount = new double[16][6];
        double[][] box1ByCount = new double[16][6];
        for (int i = 0; i < 16; ++i) {
            int layer = i / 4;
            int row = i % 4 + 1;
            box2ByCount[i] = new double[]{0.0, 4 * layer, 0.0, 16.0, 4 * layer + 4, 4 * row};
            box1ByCount[i] = new double[]{0.0, 0.0, 0.0, 16.0, 4 * layer, 16.0};
        }
        for (count = 0; count < 16; ++count) {
            box1 = Helpers.rotateShape((Direction)Direction.SOUTH, (double)box1ByCount[count][0], (double)box1ByCount[count][1], (double)box1ByCount[count][2], (double)box1ByCount[count][3], (double)box1ByCount[count][4], (double)box1ByCount[count][5]);
            box2 = Helpers.rotateShape((Direction)Direction.SOUTH, (double)box2ByCount[count][0], (double)box2ByCount[count][1], (double)box2ByCount[count][2], (double)box2ByCount[count][3], (double)box2ByCount[count][4], (double)box2ByCount[count][5]);
            shapes[0][count] = Shapes.or((VoxelShape)box1, (VoxelShape)box2);
        }
        for (count = 0; count < 16; ++count) {
            box1 = Helpers.rotateShape((Direction)Direction.EAST, (double)box1ByCount[count][0], (double)box1ByCount[count][1], (double)box1ByCount[count][2], (double)box1ByCount[count][3], (double)box1ByCount[count][4], (double)box1ByCount[count][5]);
            box2 = Helpers.rotateShape((Direction)Direction.EAST, (double)box2ByCount[count][0], (double)box2ByCount[count][1], (double)box2ByCount[count][2], (double)box2ByCount[count][3], (double)box2ByCount[count][4], (double)box2ByCount[count][5]);
            shapes[1][count] = Shapes.or((VoxelShape)box1, (VoxelShape)box2);
        }
    });

    public LogPileExBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)COUNT, (Comparable)Integer.valueOf(1)));
    }

    protected void tick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        BurningLogPileExBlock.lightLogPile((Level)level, pos);
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)context.getHorizontalDirection().getAxis())).setValue((Property)COUNT, (Comparable)Integer.valueOf(1));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder.add(new Property[]{AXIS}).add(new Property[]{COUNT}));
    }

    @NotNull
    protected BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, LevelAccessor levelAccess, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (!levelAccess.isClientSide() && levelAccess instanceof Level) {
            Level level = (Level)levelAccess;
            if (facing == Direction.DOWN && !facingState.isFaceSturdy((BlockGetter)levelAccess, facingPos, Direction.UP) && !(facingState.getBlock() instanceof LogPileExBlock)) {
                return Blocks.AIR.defaultBlockState();
            }
            if (Helpers.isBlock((BlockState)facingState, (TagKey)BlockTags.FIRE)) {
                BurningLogPileExBlock.lightLogPile(level, currentPos);
            }
        }
        return super.updateShape(state, facing, facingState, levelAccess, currentPos, facingPos);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity;
        if (!player.isShiftKeyDown() && (blockEntity = level.getBlockEntity(pos)) instanceof LogPileExBlockEntity) {
            LogPileExBlockEntity logPile = (LogPileExBlockEntity)blockEntity;
            if (Helpers.isItem((Item)stack.getItem(), (TagKey)TFCTags.Items.LOG_PILE_LOGS)) {
                LogPileExBlock.insertAndPushUp(stack, state, level, pos, logPile, false);
            } else if (stack.isEmpty()) {
                LogPileExBlock.extractFromTop(level, pos, player, false);
            }
            return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static void extractFromTop(Level level, BlockPos pos, Player player, boolean all) {
        if (level.getBlockState(pos.above()).is((Block)ModBlocks.LOG_PILE_EX.get())) {
            LogPileExBlock.extractFromTop(level, pos.above(), player, all);
        } else {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof LogPileExBlockEntity) {
                LogPileExBlockEntity logPile = (LogPileExBlockEntity)blockEntity;
                for (int i = 15; i >= 0; --i) {
                    ItemStack stack = ((ItemStackHandler)logPile.getInventory()).getStackInSlot(i);
                    if (stack.isEmpty()) continue;
                    ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)stack.split(1));
                    logPile.setAndUpdateSlots(-1);
                    if (!all) break;
                }
            }
        }
    }

    public static void insertAndPushUp(ItemStack stack, BlockState state, Level level, BlockPos pos, LogPileExBlockEntity logPile, boolean all) {
        BlockEntity stateAbove;
        LogPileExBlockEntity pileAbove;
        if (LogPileExBlock.dumbInsert(stack, state, level, pos, logPile, all) && !all) {
            return;
        }
        BlockPos abovePos = pos.above();
        if (level.getBlockState(abovePos).isAir() && logPile.isFull() && !stack.isEmpty()) {
            level.setBlockAndUpdate(abovePos, (BlockState)((Block)ModBlocks.LOG_PILE_EX.get()).defaultBlockState().setValue((Property)BlockStateProperties.HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS))));
            BlockEntity blockEntity = level.getBlockEntity(abovePos);
            if (blockEntity instanceof LogPileExBlockEntity) {
                pileAbove = (LogPileExBlockEntity)blockEntity;
                stateAbove = level.getBlockState(abovePos);
                if (LogPileExBlock.dumbInsert(stack, (BlockState)stateAbove, level, abovePos, pileAbove, all)) {
                    return;
                }
                level.removeBlock(abovePos, false);
            }
        }
        if (level.getBlockState(abovePos).getBlock() instanceof LogPileExBlock && logPile.isFull() && (stateAbove = level.getBlockEntity(abovePos)) instanceof LogPileExBlockEntity) {
            pileAbove = (LogPileExBlockEntity)stateAbove;
            stateAbove = level.getBlockState(abovePos);
            LogPileExBlock.insertAndPushUp(stack, (BlockState)stateAbove, level, abovePos, pileAbove, all);
        }
    }

    private static boolean dumbInsert(ItemStack stack, BlockState state, Level level, BlockPos pos, LogPileExBlockEntity logPile, boolean all) {
        if (all) {
            ItemStack insertStack = stack.copy();
            if ((insertStack = logPile.insertItemStack(insertStack)).getCount() < stack.getCount()) {
                Helpers.playPlaceSound(null, (LevelAccessor)level, (BlockPos)pos, (SoundType)SoundType.WOOD);
                stack.setCount(insertStack.getCount());
                logPile.setAndUpdateSlots(-1);
                return true;
            }
        } else if (logPile.insertItemStack(stack.copyWithCount(1)).isEmpty()) {
            Helpers.playPlaceSound(null, (LevelAccessor)level, (BlockPos)pos, (BlockState)state);
            stack.shrink(1);
            logPile.setAndUpdateSlots(-1);
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack getCloneItemStack(@NotNull BlockState state, @NotNull HitResult target, LevelReader level, @NotNull BlockPos pos, @NotNull Player player) {
        return level.getBlockEntity(pos, (BlockEntityType)ModBlockEntities.LOG_PILE_EX.get()).map(pile -> {
            ItemStackHandler inv = (ItemStackHandler)pile.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                ItemStack stack = inv.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                return stack.copy();
            }
            return ItemStack.EMPTY;
        }).orElse(ItemStack.EMPTY);
    }

    protected boolean canSurvive(@NotNull BlockState state, LevelReader level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        return Block.isFaceFull((VoxelShape)belowState.getCollisionShape((BlockGetter)level, pos.below()), (Direction)Direction.UP) || belowState.getBlock() instanceof LogPileExBlock;
    }

    public static VoxelShape getShapeByDirByCount(Direction.Axis axis, int count) {
        if (axis == Direction.Axis.X) {
            return SHAPES_BY_DIR_BY_COUNT[0][count - 1];
        }
        return SHAPES_BY_DIR_BY_COUNT[1][count - 1];
    }

    @NotNull
    protected VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return LogPileExBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    @NotNull
    protected VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return LogPileExBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }

    @NotNull
    protected VoxelShape getVisualShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return LogPileExBlock.getShapeByDirByCount((Direction.Axis)state.getValue(AXIS), (Integer)state.getValue((Property)COUNT));
    }
}

