/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.blocks;

import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import su.uTa4u.tfcwoodwork.blockentities.BurningLogPileExBlockEntity;
import su.uTa4u.tfcwoodwork.blockentities.ModBlockEntities;
import su.uTa4u.tfcwoodwork.blocks.BlockType;
import su.uTa4u.tfcwoodwork.blocks.BurningLogPileExBlock;
import su.uTa4u.tfcwoodwork.blocks.LogPileExBlock;
import su.uTa4u.tfcwoodwork.items.ModItems;

public final class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"tfcwoodwork");
    public static final Map<Wood, Map<BlockType, TFCBlocks.Id<Block>>> WOODS = Helpers.mapOf(Wood.class, wood -> Helpers.mapOf(BlockType.class, type -> new TFCBlocks.Id(ModBlocks.registerBlockWithItem(type.getName((RegistryWood)wood), type.sup))));
    public static final DeferredHolder<Block, Block> LOG_PILE_EX = ModBlocks.registerBlock("log_pile_ex", () -> new LogPileExBlock(ExtendedProperties.of((MapColor)MapColor.WOOD).strength(0.6f).sound(SoundType.WOOD).flammable(60, 30).blockEntity(ModBlockEntities.LOG_PILE_EX)));
    public static final DeferredHolder<Block, Block> BURNING_LOG_PILE_EX = ModBlocks.registerBlock("burning_log_pile_ex", () -> new BurningLogPileExBlock(ExtendedProperties.of((MapColor)MapColor.WOOD).randomTicks().strength(0.6f).sound(SoundType.WOOD).flammableLikeLogs().blockEntity(ModBlockEntities.BURNING_LOG_PILE_EX).serverTicks(BurningLogPileExBlockEntity::serverTick).cloneItem((ItemLike)Items.CHARCOAL).noOcclusion()));

    private ModBlocks() {
    }

    private static <T extends Block> DeferredHolder<Block, T> registerBlock(String name, Supplier<T> blockSup) {
        return BLOCKS.register(name, blockSup);
    }

    private static <T extends Block> DeferredHolder<Block, T> registerBlockWithItem(String name, Supplier<T> blockSup) {
        DeferredHolder<Block, T> ret = ModBlocks.registerBlock(name, blockSup);
        ModBlocks.registerBlockItem(name, ret);
        return ret;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredHolder<Block, T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

