/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.recipes.inworld;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.dries007.tfc.common.LevelTier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SupportType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import su.uTa4u.tfcwoodwork.ModConfig;
import su.uTa4u.tfcwoodwork.recipes.ModRecipeTypes;
import su.uTa4u.tfcwoodwork.recipes.inworld.Action;
import su.uTa4u.tfcwoodwork.recipes.inworld.InWorldRecipeInput;

@EventBusSubscriber(modid="tfcwoodwork")
public final class InWorldRecipeHandler {
    private static final Random RNG = new Random();

    @SubscribeEvent
    public static void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getEntity();
        ItemStack itemStack = player.getMainHandItem();
        if (player.getCooldowns().isOnCooldown(itemStack.getItem())) {
            event.setUseItem(TriState.FALSE);
            return;
        }
        Level level = event.getLevel();
        if (!InWorldRecipeHandler.checkFiveDirections(level, pos = event.getPos())) {
            return;
        }
        BlockState blockState = level.getBlockState(pos);
        RecipeManager recipes = level.getRecipeManager();
        InWorldRecipeInput input = new InWorldRecipeInput(blockState, itemStack);
        Optional resultOpt = recipes.getRecipeFor(ModRecipeTypes.IN_WORLD.get(), (RecipeInput)input, level);
        resultOpt.map(RecipeHolder::value).ifPresent(recipe -> {
            List<Pair<ItemStack, Action>> resultItems = recipe.resultItems();
            if (!resultItems.isEmpty()) {
                Direction dir = player.getDirection();
                for (Pair<ItemStack, Action> pair : resultItems) {
                    ((Action)((Object)((Object)pair.getSecond()))).accept(level, pos, ((ItemStack)pair.getFirst()).copy(), dir);
                }
            }
            level.setBlockAndUpdate(pos, recipe.resultState());
            InWorldRecipeHandler.damageTool(player, itemStack);
            InWorldRecipeHandler.setCooldownForItems(player, recipe.tool().getToolTagKey());
            recipe.soundInstance().ifPresent(soundInstance -> soundInstance.play(level, player, pos));
            player.swing(InteractionHand.MAIN_HAND, true);
            event.setCancellationResult(InteractionResult.sidedSuccess((boolean)level.isClientSide));
            event.setCanceled(true);
        });
    }

    private static void setCooldownForItems(Player player, TagKey<Item> tag) {
        ItemCooldowns cds = player.getCooldowns();
        for (Holder axe : BuiltInRegistries.ITEM.getOrCreateTag(tag)) {
            Object object = axe.value();
            if (!(object instanceof TieredItem)) continue;
            TieredItem tieredItem = (TieredItem)object;
            int level = 6;
            Tier tier = tieredItem.getTier();
            if (tier instanceof LevelTier) {
                LevelTier levelTier = (LevelTier)tier;
                level = levelTier.level();
            }
            cds.addCooldown((Item)tieredItem, ((Integer)((List)ModConfig.TOOL_COOLDOWNS.get()).get(level)).intValue());
        }
    }

    private static boolean checkFiveDirections(Level level, BlockPos pos) {
        for (int i = 1; i <= 5; ++i) {
            Direction dir = Direction.from3DDataValue((int)i);
            BlockPos nbour = pos.relative(dir);
            if (!level.getBlockState(nbour).isFaceSturdy((BlockGetter)level, nbour, dir.getOpposite(), SupportType.FULL)) continue;
            return false;
        }
        return true;
    }

    public static void damageTool(Player player, ItemStack inHand) {
        int uses = ((TieredItem)inHand.getItem()).getTier().getUses();
        if (RNG.nextDouble() < 400.0 / (double)uses) {
            inHand.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }
}

