/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork;

import com.mojang.logging.LogUtils;
import java.util.concurrent.CompletableFuture;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;
import su.uTa4u.tfcwoodwork.ModConfig;
import su.uTa4u.tfcwoodwork.blockentities.ModBlockEntities;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;
import su.uTa4u.tfcwoodwork.client.render.WoodProjectilefRenderer;
import su.uTa4u.tfcwoodwork.datagen.recipes.InWorldRecipeProvider;
import su.uTa4u.tfcwoodwork.entities.ModEntities;
import su.uTa4u.tfcwoodwork.items.ModItems;
import su.uTa4u.tfcwoodwork.recipes.ModRecipeSerializers;
import su.uTa4u.tfcwoodwork.recipes.ModRecipeTypes;
import su.uTa4u.tfcwoodwork.sounds.ModSounds;

@Mod(value="tfcwoodwork")
public class TFCWoodworking {
    public static final String MOD_ID = "tfcwoodwork";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"tfcwoodwork");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("woodworking", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"item_group.tfcwoodwork.woodworking")).icon(() -> new ItemStack((ItemLike)ModItems.getBark(Wood.OAK))).displayItems((p, o) -> ModItems.ITEMS.getEntries().forEach(item -> o.accept((ItemLike)item.value()))).build());

    public TFCWoodworking(IEventBus modEventBus, ModContainer modContainer) {
        ModItems.ITEMS.register(modEventBus);
        ModBlocks.BLOCKS.register(modEventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(modEventBus);
        ModSounds.SOUND_EVENTS.register(modEventBus);
        ModEntities.ENTITY_TYPES.register(modEventBus);
        ModRecipeTypes.RECIPE_TYPES.register(modEventBus);
        ModRecipeSerializers.RECIPE_SERIALIZERS.register(modEventBus);
        CREATIVE_TABS.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)ModConfig.SPEC);
    }

    public static ResourceLocation getResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    @EventBusSubscriber(modid="tfcwoodwork")
    public static final class CommonEvents {
        @SubscribeEvent
        public static void onGatherData(GatherDataEvent event) {
            DataGenerator generator = event.getGenerator();
            PackOutput output = generator.getPackOutput();
            CompletableFuture lookupProvider = event.getLookupProvider();
            generator.addProvider(event.includeServer(), (DataProvider)new InWorldRecipeProvider(output, lookupProvider));
        }
    }

    @EventBusSubscriber(modid="tfcwoodwork", value={Dist.CLIENT})
    public static final class ClientEvents {
        @SubscribeEvent
        public static void onClientSetup(FMLClientSetupEvent event) {
            EntityRenderers.register((EntityType)((EntityType)ModEntities.LOG_HALF_PROJ.get()), WoodProjectilefRenderer::new);
            EntityRenderers.register((EntityType)((EntityType)ModEntities.LOG_QUARTER_PROJ.get()), WoodProjectilefRenderer::new);
        }

        private ClientEvents() {
        }
    }
}

