/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.blockentities;

import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.common.blocks.CharcoalPileBlock;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import su.uTa4u.tfcwoodwork.blockentities.ModBlockEntities;
import su.uTa4u.tfcwoodwork.blocks.ModBlocks;

public class BurningLogPileExBlockEntity
extends TickCounterBlockEntity {
    private int logs;

    public static void serverTick(Level level, BlockPos pos, BlockState state, BurningLogPileExBlockEntity entity) {
        if (entity.lastUpdateTick > 0L && entity.getTicksSinceUpdate() > (long)((Integer)TFCConfig.SERVER.charcoalTicks.get()).intValue()) {
            entity.createCharcoal();
        }
    }

    public BurningLogPileExBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.BURNING_LOG_PILE_EX.get(), pos, state);
    }

    public void loadAdditional(CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        this.logs = nbt.getInt("logs");
        super.loadAdditional(nbt, provider);
    }

    public void saveAdditional(CompoundTag nbt, @NotNull HolderLookup.Provider provider) {
        nbt.putInt("logs", this.logs);
        super.saveAdditional(nbt, provider);
    }

    public void light(int logs) {
        this.logs = logs;
        this.resetCounter();
        this.markForSync();
    }

    public int getLogs() {
        return this.logs;
    }

    private void createCharcoal() {
        if (this.level != null && !BurningLogPileExBlockEntity.isPileBlock(this.level.getBlockState(this.worldPosition.above()))) {
            int currentAmount;
            int amount;
            int charcoal = BurningLogPileExBlockEntity.getCharcoalAmount(this.level, this.logs);
            int height = 1;
            BlockPos.MutableBlockPos currentPos = this.worldPosition.mutable().move(Direction.DOWN);
            BlockState currentState = this.level.getBlockState((BlockPos)currentPos);
            while (Helpers.isBlock((BlockState)currentState, (Block)((Block)ModBlocks.BURNING_LOG_PILE_EX.get()))) {
                ++height;
                int logs = this.level.getBlockEntity((BlockPos)currentPos, (BlockEntityType)ModBlockEntities.BURNING_LOG_PILE_EX.get()).map(BurningLogPileExBlockEntity::getLogs).orElse(0);
                charcoal += BurningLogPileExBlockEntity.getCharcoalAmount(this.level, logs);
                currentPos.move(Direction.DOWN);
                currentState = this.level.getBlockState((BlockPos)currentPos);
            }
            currentPos.set((Vec3i)this.worldPosition).move(0, 1 - height, 0);
            BlockState belowState = this.level.getBlockState(currentPos.below());
            if (Helpers.isBlock((BlockState)belowState, (Block)((Block)TFCBlocks.CHARCOAL_PILE.get())) && (amount = Mth.clamp((int)charcoal, (int)0, (int)(8 - (currentAmount = ((Integer)belowState.getValue((Property)CharcoalPileBlock.LAYERS)).intValue())))) > 0) {
                charcoal -= amount;
                this.level.setBlockAndUpdate(currentPos.below(), (BlockState)belowState.setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(currentAmount + amount)));
            }
            for (currentAmount = 0; currentAmount < height; ++currentAmount) {
                if (charcoal > 0) {
                    amount = Mth.clamp((int)charcoal, (int)0, (int)8);
                    charcoal -= amount;
                    this.level.setBlockAndUpdate((BlockPos)currentPos, (BlockState)((Block)TFCBlocks.CHARCOAL_PILE.get()).defaultBlockState().setValue((Property)CharcoalPileBlock.LAYERS, (Comparable)Integer.valueOf(amount)));
                } else {
                    this.level.setBlockAndUpdate((BlockPos)currentPos, Blocks.AIR.defaultBlockState());
                }
                currentPos.move(Direction.UP);
            }
        }
    }

    private static int getCharcoalAmount(Level level, int logs) {
        return (int)Math.clamp((float)logs * (0.25f + 0.25f * level.getRandom().nextFloat()), 0.0f, 8.0f);
    }

    private static boolean isPileBlock(BlockState state) {
        return Helpers.isBlock((BlockState)state, (Block)((Block)TFCBlocks.CHARCOAL_PILE.get())) || Helpers.isBlock((BlockState)state, (Block)((Block)ModBlocks.BURNING_LOG_PILE_EX.get()));
    }
}

