/*
 * Decompiled with CFR 0.152.
 */
package su.uTa4u.tfcwoodwork.blockentities;

import java.util.stream.IntStream;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import su.uTa4u.tfcwoodwork.ModTags;
import su.uTa4u.tfcwoodwork.blockentities.ModBlockEntities;
import su.uTa4u.tfcwoodwork.blocks.LogPileExBlock;

public class LogPileExBlockEntity
extends InventoryBlockEntity<ItemStackHandler> {
    public static final int SLOTS = 16;
    private boolean needsLogDispersion = true;
    private final int[] stackLimitBySlot = IntStream.range(0, 16).map(i -> 1).toArray();

    public LogPileExBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.LOG_PILE_EX.get(), pos, state, LogPileExBlockEntity.defaultInventory((int)16));
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (this.level != null && !this.level.isClientSide()) {
            this.suckLogsFromAbove();
            if (this.isEmpty()) {
                this.level.setBlockAndUpdate(this.worldPosition, Blocks.AIR.defaultBlockState());
            } else {
                this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)LogPileExBlock.COUNT, (Comparable)Integer.valueOf(this.logCount())));
            }
        }
    }

    public boolean isEmpty() {
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        int limit = 0;
        for (int i : this.stackLimitBySlot) {
            limit += i;
        }
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            count += stack.getCount();
        }
        return count == limit;
    }

    public int logCount() {
        int count = 0;
        for (ItemStack stack : Helpers.iterate((IItemHandler)this.inventory)) {
            if (stack.isEmpty()) continue;
            if (stack.is(ModTags.Items.LOGS_HALF)) {
                count += stack.getCount() * 2;
                continue;
            }
            if (stack.is(ModTags.Items.LOGS_QUARTER)) {
                count += stack.getCount();
                continue;
            }
            count += stack.getCount() * 4;
        }
        return Mth.clamp((int)Math.ceilDiv(count, 4), (int)1, (int)16);
    }

    private void suckLogsFromAbove() {
        LogPileExBlockEntity logPileAbove;
        BlockEntity blockEntity;
        if (this.level != null && !this.level.isClientSide() && (blockEntity = this.level.getBlockEntity(this.getBlockPos().above())) instanceof LogPileExBlockEntity && !(logPileAbove = (LogPileExBlockEntity)blockEntity).isEmpty()) {
            ItemStackHandler aboveInventory = (ItemStackHandler)logPileAbove.getInventory();
            block0: for (int i = 0; i < 16; ++i) {
                ItemStack stack = aboveInventory.getStackInSlot(i);
                if (stack.isEmpty()) continue;
                for (int j = 0; j < 16; ++j) {
                    if (i == j) continue;
                    if (stack.isEmpty()) continue block0;
                    if (((ItemStackHandler)this.inventory).getStackInSlot(j).isEmpty()) {
                        this.stackLimitBySlot[j] = LogPileExBlockEntity.getStackLimitForItem(stack);
                    }
                    stack = ((ItemStackHandler)this.inventory).insertItem(j, stack, false);
                }
            }
            logPileAbove.setAndUpdateSlots(-1);
        }
    }

    private void disperseLogsToNewSlots() {
        block0: for (int i = 0; i < 16; ++i) {
            ItemStack stack = ((ItemStackHandler)this.inventory).getStackInSlot(i);
            if (stack.getCount() <= this.stackLimitBySlot[i]) continue;
            for (int j = 0; j < 16; ++j) {
                int count;
                if (i == j) continue;
                if (stack.isEmpty()) continue block0;
                ItemStack moveToStack = ((ItemStackHandler)this.inventory).getStackInSlot(j);
                if (moveToStack.isEmpty()) {
                    this.stackLimitBySlot[j] = LogPileExBlockEntity.getStackLimitForItem(stack);
                    count = this.stackLimitBySlot[j];
                } else {
                    count = this.stackLimitBySlot[j] - moveToStack.getCount();
                }
                if (count <= 0) continue;
                ((ItemStackHandler)this.inventory).setStackInSlot(j, stack.split(count));
            }
        }
    }

    protected void onLoadAdditional() {
        if (this.needsLogDispersion) {
            this.disperseLogsToNewSlots();
            this.needsLogDispersion = false;
        }
    }

    public int getSlotStackLimit(int slot) {
        return this.stackLimitBySlot[slot];
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.isItem((Item)stack.getItem(), (TagKey)TFCTags.Items.LOG_PILE_LOGS);
    }

    public ItemStack insertItemStack(ItemStack stack) {
        for (int slot = 0; slot < ((ItemStackHandler)this.inventory).getSlots(); ++slot) {
            if (((ItemStackHandler)this.inventory).getStackInSlot(slot).isEmpty()) {
                this.stackLimitBySlot[slot] = LogPileExBlockEntity.getStackLimitForItem(stack);
            }
            if (!(stack = ((ItemStackHandler)this.inventory).insertItem(slot, stack, false)).isEmpty()) continue;
            return ItemStack.EMPTY;
        }
        return stack;
    }

    public static int getStackLimitForItem(ItemStack stack) {
        if (stack.is(ModTags.Items.LOGS_QUARTER)) {
            return 4;
        }
        if (stack.is(ModTags.Items.LOGS_HALF)) {
            return 2;
        }
        return 1;
    }
}

